/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.config;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.io.CollectionIdentifier;
import java.time.Duration;

public class CollectionMapRefreshFailedEvent
extends AbstractEvent {
    private final Throwable cause;
    private final Reason reason;
    private final CollectionIdentifier collectionIdentifier;

    public CollectionMapRefreshFailedEvent(Duration duration, Context context, CollectionIdentifier collectionIdentifier, Throwable cause, Reason reason) {
        super(Event.Severity.WARN, Event.Category.CONFIG, duration, context);
        this.cause = cause;
        this.reason = reason;
        this.collectionIdentifier = collectionIdentifier;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public String description() {
        return "Collection Map refresh (" + this.collectionIdentifier + ") failed: " + (Object)((Object)this.reason);
    }

    public static enum Reason {
        FAILED,
        NOT_SUPPORTED,
        UNKNOWN_COLLECTION,
        COLLECTION_ID_NOT_PRESENT,
        SERVER_HAS_NO_MANIFEST,
        INVALID_REQUEST,
        UNKNOWN;

    }
}

