/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class CbThrowables {
    private CbThrowables() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T extends Throwable> Optional<T> findCause(Throwable t, Class<T> type) {
        while (t != null) {
            if (type.isAssignableFrom(t.getClass())) {
                return Optional.of(type.cast(t));
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    public static boolean hasCause(Throwable t, Class<? extends Throwable> type) {
        return CbThrowables.findCause(t, type).isPresent();
    }

    public static void throwIfUnchecked(Throwable t) {
        Objects.requireNonNull(t);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public static <T extends Throwable> void throwIfInstanceOf(Throwable t, Class<T> clazz) throws T {
        Objects.requireNonNull(t);
        if (clazz.isInstance(t)) {
            throw (Throwable)clazz.cast(t);
        }
    }
}

