/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.query;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.HttpRequest;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class QueryRequest
extends BaseRequest<QueryResponse>
implements HttpRequest<QueryChunkHeader, QueryChunkRow, QueryChunkTrailer, QueryResponse> {
    private static final String URI = "/query";
    private final byte[] query;
    private final String statement;
    private final boolean idempotent;
    private final Authenticator authenticator;
    private final String contextId;
    private final String queryContext;

    public QueryRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Authenticator authenticator, String statement, byte[] query, boolean idempotent, String contextId, RequestSpan span, String queryContext) {
        super(timeout, ctx, retryStrategy, span);
        this.query = query;
        this.statement = statement;
        this.authenticator = authenticator;
        this.idempotent = idempotent;
        this.contextId = contextId;
        this.queryContext = queryContext;
    }

    @Override
    public FullHttpRequest encode() {
        ByteBuf content = Unpooled.wrappedBuffer(this.query);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, URI, content);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.context().environment().userAgent().formattedLong());
        this.authenticator.authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public QueryResponse decode(ResponseStatus status, QueryChunkHeader header, Flux<QueryChunkRow> rows, Mono<QueryChunkTrailer> trailer) {
        return new QueryResponse(status, header, rows, trailer);
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.QUERY;
    }

    public String statement() {
        return this.statement;
    }

    public Authenticator credentials() {
        return this.authenticator;
    }

    @Override
    public String operationId() {
        return this.contextId;
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }

    public String queryContext() {
        return this.queryContext;
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("operationId", RedactableArgument.redactMeta(this.operationId()));
        ctx.put("statement", RedactableArgument.redactUser(this.statement()));
        if (this.queryContext != null) {
            ctx.put("queryContext", RedactableArgument.redactMeta(this.queryContext()));
        }
        return ctx;
    }

    public String toString() {
        return "QueryRequest{query=" + RedactableArgument.redactUser(new String(this.query)) + ", statement='" + RedactableArgument.redactUser(this.statement) + '\'' + ", idempotent=" + this.idempotent + ", contextId='" + this.contextId + '\'' + ", queryContext='" + RedactableArgument.redactMeta(this.queryContext) + '\'' + '}';
    }
}

