/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.TouchResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;

public class TouchRequest
extends BaseKeyValueRequest<TouchResponse> {
    private final long expiry;

    public TouchRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, long expiry, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.expiry = expiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            extras = alloc.buffer(4);
            extras.writeInt((int)this.expiry);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.TOUCH, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras, key, MemcacheProtocol.noBody());
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        return byteBuf;
    }

    @Override
    public TouchResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        return new TouchResponse(MemcacheProtocol.decodeStatus(response), MemcacheProtocol.cas(response), MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get()));
    }
}

