/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.RemoveResponse;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class RemoveRequest
extends BaseKeyValueRequest<RemoveResponse>
implements SyncDurabilityRequest {
    private final long cas;
    private final Optional<DurabilityLevel> syncReplicationType;

    public RemoveRequest(String key, long cas, Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, Optional<DurabilityLevel> syncReplicationType, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.cas = cas;
        this.syncReplicationType = syncReplicationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf flexibleExtras = null;
        try {
            ByteBuf request;
            key = this.encodedKeyWithCollection(alloc, ctx);
            if (this.syncReplicationType.isPresent()) {
                if (!ctx.syncReplicationEnabled()) throw new DurabilityLevelNotAvailableException(KeyValueErrorContext.incompleteRequest(this));
                flexibleExtras = MemcacheProtocol.flexibleSyncReplication(alloc, this.syncReplicationType.get(), this.timeout(), this.context());
                request = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.DELETE, MemcacheProtocol.noDatatype(), this.partition(), opaque, this.cas, flexibleExtras, MemcacheProtocol.noExtras(), key, MemcacheProtocol.noBody());
            } else {
                request = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.DELETE, MemcacheProtocol.noDatatype(), this.partition(), opaque, this.cas, MemcacheProtocol.noExtras(), key, MemcacheProtocol.noBody());
            }
            byteBuf = request;
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(flexibleExtras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(flexibleExtras);
        return byteBuf;
    }

    @Override
    public RemoveResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        Optional<MutationToken> mutationToken = MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get());
        return new RemoveResponse(status, MemcacheProtocol.cas(response), mutationToken);
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }
}

