/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.search;

import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.InternalServerFailureException;
import com.couchbase.client.core.error.context.SearchErrorContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.io.netty.chunk.BaseChunkResponseParser;
import com.couchbase.client.core.json.stream.JsonStreamParser;
import com.couchbase.client.core.msg.search.SearchChunkHeader;
import com.couchbase.client.core.msg.search.SearchChunkRow;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import java.util.Optional;

public class SearchChunkResponseParser
extends BaseChunkResponseParser<SearchChunkHeader, SearchChunkRow, SearchChunkTrailer> {
    private byte[] status;
    private byte[] error;
    private byte[] facets;
    private long totalRows;
    private double maxScore;
    private long took;
    private final JsonStreamParser.Builder parserBuilder = JsonStreamParser.builder().doOnValue("/status", v -> {
        this.status = v.readBytes();
    }).doOnValue("/error", v -> {
        this.error = v.readBytes();
        this.failRows(this.errorsToThrowable(this.error));
    }).doOnValue("/hits/-", v -> this.emitRow(new SearchChunkRow(v.readBytes()))).doOnValue("/total_hits", v -> {
        this.totalRows = v.readLong();
    }).doOnValue("/max_score", v -> {
        this.maxScore = v.readDouble();
    }).doOnValue("/took", v -> {
        this.took = v.readLong();
    }).doOnValue("/facets", v -> {
        this.facets = v.readBytes();
    });

    @Override
    protected void doCleanup() {
        this.status = null;
        this.error = null;
        this.facets = null;
        this.totalRows = 0L;
        this.maxScore = 0.0;
        this.took = 0L;
    }

    @Override
    protected JsonStreamParser.Builder parserBuilder() {
        return this.parserBuilder;
    }

    @Override
    public Optional<SearchChunkHeader> header(boolean lastChunk) {
        return Optional.ofNullable(this.status).map(SearchChunkHeader::new);
    }

    @Override
    public Optional<CouchbaseException> error() {
        return Optional.ofNullable(this.error).map(this::errorsToThrowable);
    }

    private CouchbaseException errorsToThrowable(byte[] bytes) {
        int statusCode = this.responseHeader().status().code();
        String errorDecoded = bytes == null || bytes.length == 0 ? "" : new String(bytes, CharsetUtil.UTF_8);
        SearchErrorContext errorContext = new SearchErrorContext(HttpProtocol.decodeStatus(this.responseHeader().status()), this.requestContext(), statusCode);
        if (statusCode == 400 && errorDecoded.contains("index not found")) {
            return new IndexNotFoundException(errorContext);
        }
        if (statusCode == 500) {
            return new InternalServerFailureException(errorContext);
        }
        if (statusCode == 401 || statusCode == 403) {
            return new AuthenticationFailureException("Could not authenticate search query", errorContext, null);
        }
        return new CouchbaseException("Unknown search error: " + errorDecoded, errorContext);
    }

    @Override
    public void signalComplete() {
        this.completeRows();
        this.completeTrailer(new SearchChunkTrailer(this.totalRows, this.maxScore, this.took, this.facets));
    }
}

