/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;

public class OrphanReporterConfig {
    private static final Duration DEFAULT_EMIT_INTERVAL = Duration.ofSeconds(10L);
    private static final int DEFAULT_SAMPLE_SIZE = 10;
    private static final int DEFAULT_QUEUE_LENGTH = 1024;
    private static final boolean DEFAULT_ENABLED = true;
    private final Duration emitInterval;
    private final int sampleSize;
    private final int queueLength;
    private final boolean enabled;

    private OrphanReporterConfig(Builder builder) {
        this.sampleSize = builder.sampleSize;
        this.emitInterval = builder.emitInterval;
        this.queueLength = builder.queueLength;
        this.enabled = builder.enabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OrphanReporterConfig create() {
        return OrphanReporterConfig.builder().build();
    }

    public static Builder sampleSize(int sampleSize) {
        return OrphanReporterConfig.builder().sampleSize(sampleSize);
    }

    public static Builder emitInterval(Duration emitInterval) {
        return OrphanReporterConfig.builder().emitInterval(emitInterval);
    }

    public static Builder queueLength(int queueLength) {
        return OrphanReporterConfig.builder().queueLength(queueLength);
    }

    public static Builder enabled(boolean enabled) {
        return OrphanReporterConfig.builder().enabled(enabled);
    }

    public Duration emitInterval() {
        return this.emitInterval;
    }

    public int sampleSize() {
        return this.sampleSize;
    }

    public int queueLength() {
        return this.queueLength;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("emitIntervalMs", this.emitInterval.toMillis());
        export.put("sampleSize", this.sampleSize);
        export.put("queueLength", this.queueLength);
        export.put("enabled", this.enabled);
        return export;
    }

    static /* synthetic */ Duration access$400() {
        return DEFAULT_EMIT_INTERVAL;
    }

    public static class Builder {
        private Duration emitInterval = OrphanReporterConfig.access$400();
        private int sampleSize = 10;
        private int queueLength = 1024;
        private boolean enabled = true;

        public Builder emitInterval(Duration emitInterval) {
            if (emitInterval.isZero()) {
                throw InvalidArgumentException.fromMessage("Emit interval needs to be greater than 0");
            }
            this.emitInterval = emitInterval;
            return this;
        }

        public Builder queueLength(int queueLength) {
            this.queueLength = queueLength;
            return this;
        }

        public Builder sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public OrphanReporterConfig build() {
            return new OrphanReporterConfig(this);
        }
    }
}

