/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import java.util.Optional;

public class UserAgent {
    private final String name;
    private final String version;
    private final Optional<String> os;
    private final Optional<String> platform;
    private final String formattedLong;
    private final String formattedShort;

    public UserAgent(String name, Optional<String> version, Optional<String> os, Optional<String> platform) {
        this.name = name;
        this.version = version.orElse("0.0.0");
        this.os = os;
        this.platform = platform;
        this.formattedLong = "couchbase-" + name + "/" + this.version + this.formatExtras();
        this.formattedShort = name + "/" + this.version + this.formatExtras();
    }

    private String formatExtras() {
        if (this.os.isPresent() && this.platform.isPresent()) {
            return " (" + this.os.get() + "; " + this.platform.get() + ")";
        }
        if (this.os.isPresent()) {
            return " (" + this.os.get() + ")";
        }
        if (this.platform.isPresent()) {
            return " (" + this.platform.get() + ")";
        }
        return "";
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Optional<String> os() {
        return this.os;
    }

    public Optional<String> platform() {
        return this.platform;
    }

    public String formattedLong() {
        return this.formattedLong;
    }

    public String formattedShort() {
        return this.formattedShort;
    }

    public String toString() {
        return "UserAgent{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", os=" + this.os + ", platform=" + this.platform + ", formattedLong='" + this.formattedLong + '\'' + ", formattedShort='" + this.formattedShort + '\'' + '}';
    }
}

