/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.request.SuspiciousExpiryDurationEvent;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class ExpiryUtils {
    private static final int RELATIVE_EXPIRY_CUTOFF_SECONDS = (int)TimeUnit.DAYS.toSeconds(30L);
    private static final int WORKAROUND_EXPIRY_CUTOFF_SECONDS = (int)TimeUnit.DAYS.toSeconds(365L) * 50;

    private ExpiryUtils() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static long getAdjustedExpirySeconds(Duration duration, EventBus eventBus) {
        long seconds = duration.getSeconds();
        if (seconds < (long)RELATIVE_EXPIRY_CUTOFF_SECONDS) {
            return seconds;
        }
        if (seconds > (long)WORKAROUND_EXPIRY_CUTOFF_SECONDS) {
            eventBus.publish(new SuspiciousExpiryDurationEvent(duration));
            return seconds;
        }
        return System.currentTimeMillis() / 1000L + seconds;
    }
}

