/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

@Stability.Internal
public class DnsSrv {
    private static Hashtable<String, String> DNS_ENV = new Hashtable();
    private static final String DEFAULT_DNS_FACTORY = "com.sun.jndi.dns.DnsContextFactory";
    private static final String DEFAULT_DNS_PROVIDER = "dns:";
    public static final String DEFAULT_DNS_SERVICE = "_couchbase._tcp.";
    public static final String DEFAULT_DNS_SECURE_SERVICE = "_couchbases._tcp.";

    public static void setDnsEnvParameter(String key, String value) {
        DNS_ENV.put(key, value);
    }

    private DnsSrv() {
    }

    public static List<String> fromDnsSrv(String serviceName, boolean full, boolean secure) throws NamingException {
        return DnsSrv.fromDnsSrv(serviceName, full, secure, null);
    }

    public static List<String> fromDnsSrv(String serviceName, boolean full, boolean secure, String nameServerIP) throws NamingException {
        InitialDirContext ctx;
        String fullService = full ? serviceName : (secure ? DEFAULT_DNS_SECURE_SERVICE : DEFAULT_DNS_SERVICE) + serviceName;
        if (nameServerIP == null || nameServerIP.isEmpty()) {
            ctx = new InitialDirContext(DNS_ENV);
        } else {
            Hashtable<String, String> finalEnv = new Hashtable<String, String>(DNS_ENV);
            finalEnv.put("java.naming.provider.url", "dns://" + nameServerIP);
            ctx = new InitialDirContext(finalEnv);
        }
        return DnsSrv.loadDnsRecords(fullService, ctx);
    }

    static List<String> loadDnsRecords(String serviceName, DirContext ctx) throws NamingException {
        Attributes attrs = ctx.getAttributes(serviceName, new String[]{"SRV"});
        NamingEnumeration<?> servers = attrs.get("srv").getAll();
        ArrayList<String> records = new ArrayList<String>();
        while (servers.hasMore()) {
            DnsRecord record = DnsRecord.fromString((String)servers.next());
            records.add(record.getHost());
        }
        return records;
    }

    static {
        DNS_ENV.put("java.naming.factory.initial", DEFAULT_DNS_FACTORY);
        DNS_ENV.put("java.naming.provider.url", DEFAULT_DNS_PROVIDER);
    }

    static class DnsRecord {
        private final int priority;
        private final int weight;
        private final int port;
        private final String host;

        DnsRecord(int priority, int weight, int port, String host) {
            this.priority = priority;
            this.weight = weight;
            this.port = port;
            this.host = host.replaceAll("\\.$", "");
        }

        public String getHost() {
            return this.host;
        }

        static DnsRecord fromString(String input) {
            String[] splitted = input.split(" ");
            return new DnsRecord(Integer.parseInt(splitted[0]), Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]), splitted[3]);
        }

        public String toString() {
            return "DnsRecord{priority=" + this.priority + ", weight=" + this.weight + ", port=" + this.port + ", host='" + this.host + '\'' + '}';
        }
    }
}

