/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.view;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.HttpRequest;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.ScopedRequest;
import com.couchbase.client.core.msg.view.ViewChunkHeader;
import com.couchbase.client.core.msg.view.ViewChunkRow;
import com.couchbase.client.core.msg.view.ViewChunkTrailer;
import com.couchbase.client.core.msg.view.ViewResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ViewRequest
extends BaseRequest<ViewResponse>
implements HttpRequest<ViewChunkHeader, ViewChunkRow, ViewChunkTrailer, ViewResponse>,
ScopedRequest {
    public static final String OPERATION_NAME = "view";
    private final Authenticator authenticator;
    private final String bucket;
    private final boolean development;
    private final String design;
    private final String view;
    private final String query;
    private final Optional<byte[]> keysJson;

    public ViewRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Authenticator authenticator, String bucket, String design, String view, String query, Optional<byte[]> keysJson, boolean development, InternalSpan span) {
        super(timeout, ctx, retryStrategy, span);
        this.authenticator = Objects.requireNonNull(authenticator);
        this.bucket = Objects.requireNonNull(bucket);
        this.design = Objects.requireNonNull(design);
        this.view = Objects.requireNonNull(view);
        this.development = development;
        this.query = Objects.requireNonNull(query);
        this.keysJson = Objects.requireNonNull(keysJson);
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.VIEWS;
    }

    @Override
    public FullHttpRequest encode() {
        StringBuilder path = new StringBuilder();
        path.append("/").append(this.bucket).append("/_design/");
        path.append(this.development ? "dev_" + this.design : this.design);
        path.append("/_view/");
        path.append(this.view);
        path.append("?").append(this.query);
        ByteBuf content = this.keysJson.isPresent() ? Unpooled.copiedBuffer(this.keysJson.get()) : Unpooled.EMPTY_BUFFER;
        HttpMethod method = this.keysJson.isPresent() ? HttpMethod.POST : HttpMethod.GET;
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path.toString(), content);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes()).set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.context().environment().userAgent().formattedLong());
        this.authenticator.authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public ViewResponse decode(ResponseStatus status, ViewChunkHeader header, Flux<ViewChunkRow> rows, Mono<ViewChunkTrailer> trailer) {
        return new ViewResponse(status, header, rows, trailer);
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("bucket", RedactableArgument.redactMeta(this.bucket));
        ctx.put("designDoc", RedactableArgument.redactMeta(this.design));
        ctx.put("viewName", RedactableArgument.redactMeta(this.view));
        ctx.put("development", this.development);
        return ctx;
    }
}

