/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.view;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpResponse;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.io.netty.HttpChannelContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.ScopedRequest;
import com.couchbase.client.core.msg.TargetedRequest;
import com.couchbase.client.core.msg.view.ViewPingResponse;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;

public class ViewPingRequest
extends BaseRequest<ViewPingResponse>
implements NonChunkedHttpRequest<ViewPingResponse>,
TargetedRequest,
ScopedRequest {
    private final NodeIdentifier target;
    private final String bucket;

    public ViewPingRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, String bucket, NodeIdentifier target) {
        super(timeout, ctx, retryStrategy);
        this.target = target;
        this.bucket = bucket;
    }

    @Override
    public ViewPingResponse decode(FullHttpResponse response, HttpChannelContext context) {
        byte[] dst = new byte[response.content().readableBytes()];
        response.content().readBytes(dst);
        return new ViewPingResponse(HttpProtocol.decodeStatus(response.status()), dst, context.channelId().asShortText());
    }

    @Override
    public FullHttpRequest encode() {
        return new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.VIEWS;
    }

    @Override
    public NodeIdentifier target() {
        return this.target;
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("bucket", this.bucket);
        if (this.target != null) {
            ctx.put("target", RedactableArgument.redactSystem(this.target.address()));
        }
        return ctx;
    }
}

