/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.ResponseStatusDetails;

public class ObserveViaCasResponse
extends BaseResponse {
    private final long cas;
    private final ObserveStatus observeStatus;
    private final boolean active;
    private final ResponseStatusDetails statusDetails;

    public ObserveViaCasResponse(ResponseStatus status, long cas, ObserveStatus observeStatus, boolean active, ResponseStatusDetails statusDetails) {
        super(status);
        this.cas = cas;
        this.observeStatus = observeStatus;
        this.active = active;
        this.statusDetails = statusDetails;
    }

    public long cas() {
        return this.cas;
    }

    public ObserveStatus observeStatus() {
        return this.observeStatus;
    }

    public boolean active() {
        return this.active;
    }

    public ResponseStatusDetails statusDetails() {
        return this.statusDetails;
    }

    public String toString() {
        return "ObserveViaCasResponse{cas=" + this.cas + ", observeStatus=" + (Object)((Object)this.observeStatus) + ", active=" + this.active + ", statusDetails=" + this.statusDetails + '}';
    }

    public static enum ObserveStatus {
        UNKNOWN(-16),
        UNINITIALIZED(-1),
        MODIFIED(-2),
        FOUND_PERSISTED(1),
        FOUND_NOT_PERSISTED(0),
        NOT_FOUND_PERSISTED(-128),
        NOT_FOUND_NOT_PERSISTED(-127);

        private final byte value;

        private ObserveStatus(byte b) {
            this.value = b;
        }

        public static ObserveStatus valueOf(byte b) {
            switch (b) {
                case 0: {
                    return FOUND_NOT_PERSISTED;
                }
                case 1: {
                    return FOUND_PERSISTED;
                }
                case -128: {
                    return NOT_FOUND_PERSISTED;
                }
                case -127: {
                    return NOT_FOUND_NOT_PERSISTED;
                }
                case -2: {
                    return MODIFIED;
                }
                case -16: {
                    return UNKNOWN;
                }
            }
            return UNINITIALIZED;
        }

        public byte value() {
            return this.value;
        }
    }
}

