/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.events.io.DurabilityTimeoutCoercedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.org.iq80.snappy.Snappy;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.SubDocumentErrorContext;
import com.couchbase.client.core.error.subdoc.DeltaInvalidException;
import com.couchbase.client.core.error.subdoc.DocumentNotJsonException;
import com.couchbase.client.core.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.core.error.subdoc.NumberTooBigException;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathMismatchException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.error.subdoc.PathTooDeepException;
import com.couchbase.client.core.error.subdoc.ValueInvalidException;
import com.couchbase.client.core.error.subdoc.ValueTooDeepException;
import com.couchbase.client.core.error.subdoc.XattrCannotModifyVirtualAttributeException;
import com.couchbase.client.core.error.subdoc.XattrInvalidFlagComboException;
import com.couchbase.client.core.error.subdoc.XattrInvalidKeyComboException;
import com.couchbase.client.core.error.subdoc.XattrInvalidOrderException;
import com.couchbase.client.core.error.subdoc.XattrUnknownMacroException;
import com.couchbase.client.core.error.subdoc.XattrUnknownVirtualAttributeException;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import java.time.Duration;
import java.util.Optional;

public enum MemcacheProtocol {

    public static final int UNSIGNED_SHORT_MAX = 65535;
    static final int HEADER_SIZE = 24;
    static final int MAGIC_OFFSET = 0;
    static final int OPCODE_OFFSET = 1;
    static final int DATATYPE_OFFSET = 5;
    static final int STATUS_OFFSET = 6;
    static final int TOTAL_LENGTH_OFFSET = 8;
    static final int OPAQUE_OFFSET = 12;
    static final int CAS_OFFSET = 16;
    public static final byte SYNC_REPLICATION_FLEXIBLE_IDENT = 16;
    public static final short SYNC_REPLICATION_TIMEOUT_FLOOR_MS = 1500;
    public static final byte FRAMING_EXTRAS_TRACING = 0;

    public static ByteBuf flexibleRequest(ByteBufAllocator alloc, Opcode opcode, byte datatype, short partition, int opaque, long cas, ByteBuf framingExtras, ByteBuf extras, ByteBuf key, ByteBuf body) {
        int keySize = key.readableBytes();
        int extrasSize = extras.readableBytes();
        int framingExtrasSize = framingExtras.readableBytes();
        int totalBodySize = framingExtrasSize + extrasSize + keySize + body.readableBytes();
        return alloc.buffer(24 + totalBodySize).writeByte(Magic.FLEXIBLE_REQUEST.magic()).writeByte(opcode.opcode()).writeByte(framingExtrasSize).writeByte(keySize).writeByte(extrasSize).writeByte(datatype).writeShort(partition).writeInt(totalBodySize).writeInt(opaque).writeLong(cas).writeBytes(framingExtras).writeBytes(extras).writeBytes(key).writeBytes(body);
    }

    public static ByteBuf request(ByteBufAllocator alloc, Opcode opcode, byte datatype, short partition, int opaque, long cas, ByteBuf extras, ByteBuf key, ByteBuf body) {
        int keySize = key.readableBytes();
        int extrasSize = extras.readableBytes();
        int totalBodySize = extrasSize + keySize + body.readableBytes();
        return alloc.buffer(24 + totalBodySize).writeByte(Magic.REQUEST.magic()).writeByte(opcode.opcode()).writeShort(keySize).writeByte(extrasSize).writeByte(datatype).writeShort(partition).writeInt(totalBodySize).writeInt(opaque).writeLong(cas).writeBytes(extras).writeBytes(key).writeBytes(body);
    }

    public static ByteBuf response(ByteBufAllocator alloc, Opcode opcode, byte datatype, short status, int opaque, long cas, ByteBuf extras, ByteBuf key, ByteBuf body) {
        int keySize = key.readableBytes();
        int extrasSize = extras.readableBytes();
        int totalBodySize = extrasSize + keySize + body.readableBytes();
        return alloc.buffer(24 + totalBodySize).writeByte(Magic.RESPONSE.magic()).writeByte(opcode.opcode()).writeShort(keySize).writeByte(extrasSize).writeByte(datatype).writeShort(status).writeInt(totalBodySize).writeInt(opaque).writeLong(cas).writeBytes(extras).writeBytes(key).writeBytes(body);
    }

    public static short status(ByteBuf message) {
        return message.getShort(6);
    }

    public static boolean successful(ByteBuf message) {
        return MemcacheProtocol.status(message) == Status.SUCCESS.status();
    }

    static byte opcode(ByteBuf message) {
        return message.getByte(1);
    }

    public static byte datatype(ByteBuf message) {
        return message.getByte(5);
    }

    static int opaque(ByteBuf message) {
        return message.getInt(12);
    }

    public static long cas(ByteBuf message) {
        return message.getLong(16);
    }

    public static Optional<ByteBuf> body(ByteBuf message) {
        if (message == null) {
            return Optional.empty();
        }
        boolean flexible = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic();
        int totalBodyLength = message.getInt(8);
        short keyLength = flexible ? message.getByte(3) : message.getShort(2);
        byte flexibleExtrasLength = flexible ? message.getByte(2) : (byte)0;
        byte extrasLength = message.getByte(4);
        int bodyLength = totalBodyLength - keyLength - extrasLength - flexibleExtrasLength;
        if (bodyLength > 0) {
            return Optional.of(message.slice(24 + flexibleExtrasLength + extrasLength + keyLength, bodyLength));
        }
        return Optional.empty();
    }

    public static Optional<ByteBuf> extras(ByteBuf message) {
        byte flexibleExtrasLength;
        boolean flexible = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic();
        byte extrasLength = message.getByte(4);
        byte by = flexibleExtrasLength = flexible ? message.getByte(2) : (byte)0;
        if (extrasLength > 0) {
            return Optional.of(message.slice(24 + flexibleExtrasLength, extrasLength));
        }
        return Optional.empty();
    }

    public static Optional<ByteBuf> flexibleExtras(ByteBuf message) {
        boolean flexible;
        boolean bl = flexible = message.getByte(0) == Magic.FLEXIBLE_RESPONSE.magic();
        if (flexible) {
            byte flexibleExtrasLength = message.getByte(2);
            if (flexibleExtrasLength > 0) {
                return Optional.of(message.slice(24, flexibleExtrasLength));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static boolean verifyRequest(ByteBuf request) {
        int readableBytes = request.readableBytes();
        if (readableBytes < 24) {
            return false;
        }
        byte magic = request.getByte(0);
        int bodyPlusHeader = request.getInt(8) + 24;
        return (magic == Magic.REQUEST.magic() || magic == Magic.FLEXIBLE_REQUEST.magic()) && readableBytes == bodyPlusHeader;
    }

    static boolean verifyResponse(ByteBuf response) {
        int readableBytes = response.readableBytes();
        if (readableBytes < 24) {
            return false;
        }
        byte magic = response.getByte(0);
        int bodyPlusHeader = response.getInt(8) + 24;
        return (magic == Magic.RESPONSE.magic() || magic == Magic.FLEXIBLE_RESPONSE.magic()) && readableBytes == bodyPlusHeader;
    }

    public static ByteBuf noKey() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static ByteBuf noExtras() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static ByteBuf noFramingExtras() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static ByteBuf noBody() {
        return Unpooled.EMPTY_BUFFER;
    }

    public static byte noDatatype() {
        return 0;
    }

    public static short noPartition() {
        return 0;
    }

    public static int noOpaque() {
        return 0;
    }

    public static long noCas() {
        return 0L;
    }

    public static ResponseStatus decodeStatus(ByteBuf message) {
        return MemcacheProtocol.decodeStatus(MemcacheProtocol.status(message));
    }

    public static ByteBuf flexibleSyncReplication(ByteBufAllocator alloc, DurabilityLevel type, Duration timeout, CoreContext ctx) {
        int deadline;
        long userTimeout = timeout.toMillis();
        if (userTimeout >= 65535L) {
            deadline = 65534;
            ctx.environment().eventBus().publish(new DurabilityTimeoutCoercedEvent(ctx, userTimeout, deadline));
        } else {
            deadline = (int)((double)userTimeout * 0.9);
        }
        if (deadline < 1500) {
            deadline = 1500;
            ctx.environment().eventBus().publish(new DurabilityTimeoutCoercedEvent(ctx, userTimeout, deadline));
        }
        ByteBuf flexibleExtras = alloc.buffer(3);
        flexibleExtras.writeByte(19);
        flexibleExtras.writeByte(type.code());
        flexibleExtras.writeShort(deadline);
        return flexibleExtras;
    }

    public static long parseServerDurationFromResponse(ByteBuf response) {
        Optional<ByteBuf> frames = MemcacheProtocol.flexibleExtras(response);
        if (frames.isPresent()) {
            ByteBuf frame = frames.get();
            while (frame.readableBytes() > 0) {
                byte control = frame.readByte();
                byte id = (byte)(control & 0xF0);
                byte len = (byte)(control & 0xF);
                if (id == 0) {
                    return Math.round(Math.pow(frame.readUnsignedShort(), 1.74) / 2.0);
                }
                frame.skipBytes(len);
            }
        } else {
            return 0L;
        }
        return 0L;
    }

    public static ResponseStatus decodeStatus(short status) {
        if (status == Status.SUCCESS.status) {
            return ResponseStatus.SUCCESS;
        }
        if (status == Status.NOT_FOUND.status) {
            return ResponseStatus.NOT_FOUND;
        }
        if (status == Status.NOT_SUPPORTED.status) {
            return ResponseStatus.UNSUPPORTED;
        }
        if (status == Status.ACCESS_ERROR.status) {
            return ResponseStatus.NO_ACCESS;
        }
        if (status == Status.OUT_OF_MEMORY.status) {
            return ResponseStatus.OUT_OF_MEMORY;
        }
        if (status == Status.SERVER_BUSY.status) {
            return ResponseStatus.SERVER_BUSY;
        }
        if (status == Status.TEMPORARY_FAILURE.status) {
            return ResponseStatus.TEMPORARY_FAILURE;
        }
        if (status == Status.NOT_MY_VBUCKET.status) {
            return ResponseStatus.NOT_MY_VBUCKET;
        }
        if (status == Status.LOCKED.status) {
            return ResponseStatus.LOCKED;
        }
        if (status == Status.EXISTS.status) {
            return ResponseStatus.EXISTS;
        }
        if (status == Status.TOO_BIG.status) {
            return ResponseStatus.TOO_BIG;
        }
        if (status == Status.NOT_STORED.status) {
            return ResponseStatus.NOT_STORED;
        }
        if (status == Status.DURABILITY_INVALID_LEVEL.status) {
            return ResponseStatus.DURABILITY_INVALID_LEVEL;
        }
        if (status == Status.DURABILITY_IMPOSSIBLE.status) {
            return ResponseStatus.DURABILITY_IMPOSSIBLE;
        }
        if (status == Status.SYNC_WRITE_AMBIGUOUS.status) {
            return ResponseStatus.SYNC_WRITE_AMBIGUOUS;
        }
        if (status == Status.SYNC_WRITE_IN_PROGRESS.status) {
            return ResponseStatus.SYNC_WRITE_IN_PROGRESS;
        }
        if (status == Status.SYNC_WRITE_RE_COMMIT_IN_PROGRESS.status) {
            return ResponseStatus.SYNC_WRITE_RE_COMMIT_IN_PROGRESS;
        }
        if (status == Status.SUBDOC_MULTI_PATH_FAILURE.status || status == Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status || status == Status.SUBDOC_DOC_NOT_JSON.status || status == Status.SUBDOC_XATTR_INVALID_KEY_COMBO.status || status == Status.SUBDOC_DOC_TOO_DEEP.status || status == Status.SUBDOC_INVALID_COMBO.status) {
            return ResponseStatus.SUBDOC_FAILURE;
        }
        if (status == Status.SUBDOC_SUCCESS_DELETED_DOCUMENT.status) {
            return ResponseStatus.SUCCESS;
        }
        if (status == Status.UNKNOWN_COLLECTION.status) {
            return ResponseStatus.UNKNOWN_COLLECTION;
        }
        if (status == Status.NO_BUCKET.status) {
            return ResponseStatus.NO_BUCKET;
        }
        if (status == Status.INTERNAL_SERVER_ERROR.status) {
            return ResponseStatus.INTERNAL_SERVER_ERROR;
        }
        if (status == Status.NOT_INITIALIZED.status) {
            return ResponseStatus.NOT_INITIALIZED;
        }
        if (status == Status.INVALID_REQUEST.status) {
            return ResponseStatus.INVALID_REQUEST;
        }
        return ResponseStatus.UNKNOWN;
    }

    public static SubDocumentOpResponseStatus decodeSubDocumentStatus(short status) {
        if (status == Status.SUCCESS.status) {
            return SubDocumentOpResponseStatus.SUCCESS;
        }
        if (status == Status.SUBDOC_PATH_NOT_FOUND.status) {
            return SubDocumentOpResponseStatus.PATH_NOT_FOUND;
        }
        if (status == Status.SUBDOC_PATH_MISMATCH.status) {
            return SubDocumentOpResponseStatus.PATH_MISMATCH;
        }
        if (status == Status.SUBDOC_PATH_INVALID.status) {
            return SubDocumentOpResponseStatus.PATH_INVALID;
        }
        if (status == Status.SUBDOC_PATH_TOO_BIG.status) {
            return SubDocumentOpResponseStatus.PATH_TOO_BIG;
        }
        if (status == Status.SUBDOC_DOC_TOO_DEEP.status) {
            return SubDocumentOpResponseStatus.DOC_TOO_DEEP;
        }
        if (status == Status.SUBDOC_VALUE_CANTINSERT.status) {
            return SubDocumentOpResponseStatus.VALUE_CANTINSERT;
        }
        if (status == Status.SUBDOC_DOC_NOT_JSON.status) {
            return SubDocumentOpResponseStatus.DOC_NOT_JSON;
        }
        if (status == Status.SUBDOC_NUM_RANGE.status) {
            return SubDocumentOpResponseStatus.NUM_RANGE;
        }
        if (status == Status.SUBDOC_DELTA_RANGE.status) {
            return SubDocumentOpResponseStatus.DELTA_RANGE;
        }
        if (status == Status.SUBDOC_PATH_EXISTS.status) {
            return SubDocumentOpResponseStatus.PATH_EXISTS;
        }
        if (status == Status.SUBDOC_VALUE_TOO_DEEP.status) {
            return SubDocumentOpResponseStatus.VALUE_TOO_DEEP;
        }
        if (status == Status.SUBDOC_INVALID_COMBO.status) {
            return SubDocumentOpResponseStatus.INVALID_COMBO;
        }
        if (status == Status.SUBDOC_MULTI_PATH_FAILURE.status) {
            return SubDocumentOpResponseStatus.MULTI_PATH_FAILURE;
        }
        if (status == Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status) {
            return SubDocumentOpResponseStatus.MULTI_PATH_FAILURE;
        }
        if (status == Status.SUBDOC_XATTR_INVALID_FLAG_COMBO.status) {
            return SubDocumentOpResponseStatus.XATTR_INVALID_FLAG_COMBO;
        }
        if (status == Status.SUBDOC_XATTR_INVALID_KEY_COMBO.status) {
            return SubDocumentOpResponseStatus.XATTR_INVALID_KEY_COMBO;
        }
        if (status == Status.SUBDOC_XATTR_UNKNOWN_MACRO.status) {
            return SubDocumentOpResponseStatus.XATTR_UNKNOWN_MACRO;
        }
        if (status == Status.SUBDOC_SUCCESS_DELETED_DOCUMENT.status) {
            return SubDocumentOpResponseStatus.SUCCESS_DELETED_DOCUMENT;
        }
        if (status == Status.SUBDOC_XATTR_UNKNOWN_VATTR.status) {
            return SubDocumentOpResponseStatus.XATTR_UNKNOWN_VATTR;
        }
        if (status == Status.SUBDOC_XATTR_CANNOT_MODIFY_VATTR.status) {
            return SubDocumentOpResponseStatus.XATTR_CANNOT_MODIFY_VATTR;
        }
        if (status == Status.SUBDOC_INVALID_XATTR_ORDER.status) {
            return SubDocumentOpResponseStatus.XATTR_INVALID_ORDER;
        }
        return SubDocumentOpResponseStatus.UNKNOWN;
    }

    public static CouchbaseException mapSubDocumentError(KeyValueRequest<?> request, SubDocumentOpResponseStatus status, String path, int index) {
        SubDocumentErrorContext ctx = new SubDocumentErrorContext(KeyValueErrorContext.completedRequest(request, ResponseStatus.SUBDOC_FAILURE), index, path, status);
        switch (status) {
            case PATH_NOT_FOUND: {
                return new PathNotFoundException(ctx);
            }
            case PATH_MISMATCH: {
                return new PathMismatchException(ctx);
            }
            case PATH_TOO_BIG: {
                return new PathTooDeepException(ctx);
            }
            case DOC_TOO_DEEP: {
                return new DocumentTooDeepException(ctx);
            }
            case VALUE_CANTINSERT: {
                return new ValueInvalidException(ctx);
            }
            case DOC_NOT_JSON: {
                return new DocumentNotJsonException(ctx);
            }
            case NUM_RANGE: {
                return new NumberTooBigException(ctx);
            }
            case DELTA_RANGE: {
                return new DeltaInvalidException(ctx);
            }
            case PATH_EXISTS: {
                return new PathExistsException(ctx);
            }
            case VALUE_TOO_DEEP: {
                return new ValueTooDeepException(ctx);
            }
            case XATTR_INVALID_FLAG_COMBO: {
                return new XattrInvalidFlagComboException(ctx);
            }
            case XATTR_UNKNOWN_MACRO: {
                return new XattrUnknownMacroException(ctx);
            }
            case XATTR_INVALID_KEY_COMBO: {
                return new XattrInvalidKeyComboException(ctx);
            }
            case XATTR_UNKNOWN_VATTR: {
                return new XattrUnknownVirtualAttributeException(ctx);
            }
            case XATTR_INVALID_ORDER: {
                return new XattrInvalidOrderException(ctx);
            }
            case XATTR_CANNOT_MODIFY_VATTR: {
                return new XattrCannotModifyVirtualAttributeException(ctx);
            }
        }
        return new CouchbaseException("Unknown SubDocument response code", ctx);
    }

    public static ByteBuf tryCompression(byte[] input, double minRatio) {
        byte[] compressed = Snappy.compress(input);
        if ((double)compressed.length / (double)input.length > minRatio) {
            return null;
        }
        return Unpooled.wrappedBuffer(compressed);
    }

    public static byte[] tryDecompression(byte[] input, byte datatype) {
        if ((datatype & Datatype.SNAPPY.datatype()) == Datatype.SNAPPY.datatype()) {
            return Snappy.uncompress(input, 0, input.length);
        }
        return input;
    }

    public static String messageToString(ByteBuf message) {
        StringBuilder sb = new StringBuilder();
        byte magic = message.getByte(0);
        sb.append(String.format("Magic: 0x%x (%s)\n", new Object[]{magic, Magic.of(magic)}));
        sb.append(String.format("Opcode: 0x%x\n", MemcacheProtocol.opcode(message)));
        if (Magic.of(magic).isFlexible()) {
            sb.append(String.format("Framing Extras Length: %d\n", message.getByte(2)));
            sb.append(String.format("Key Length: %d\n", message.getByte(3)));
        } else {
            sb.append(String.format("Key Length: %d\n", message.getShort(2)));
        }
        sb.append(String.format("Extras Length: %d\n", message.getByte(4)));
        sb.append(String.format("Datatype: 0x%x\n", MemcacheProtocol.datatype(message)));
        if (Magic.of(magic).isRequest()) {
            sb.append(String.format("VBucket ID: 0x%x\n", MemcacheProtocol.status(message)));
        } else {
            sb.append(String.format("Status: 0x%x\n", MemcacheProtocol.status(message)));
        }
        sb.append(String.format("Total Body Length: %d\n", message.getByte(8)));
        sb.append(String.format("Opaque: 0x%x\n", MemcacheProtocol.opaque(message)));
        sb.append(String.format("CAS: 0x%x\n", MemcacheProtocol.cas(message)));
        return sb.toString();
    }

    public static Optional<MutationToken> extractToken(boolean enabled, short partition, ByteBuf msg, String bucket) {
        if (!enabled || MemcacheProtocol.decodeStatus(msg) != ResponseStatus.SUCCESS) {
            return Optional.empty();
        }
        return MemcacheProtocol.extras(msg).map(e -> new MutationToken(partition, e.readLong(), e.readLong(), bucket));
    }

    public static enum Datatype {
        SNAPPY(2),
        XATTR(4);

        private final byte datatype;

        private Datatype(byte datatype) {
            this.datatype = datatype;
        }

        public byte datatype() {
            return this.datatype;
        }
    }

    public static enum Status {
        SUCCESS(0),
        NOT_FOUND(1),
        EXISTS(2),
        TOO_BIG(3),
        INVALID_REQUEST(4),
        NOT_STORED(5),
        NOT_MY_VBUCKET(7),
        NO_BUCKET(8),
        LOCKED(9),
        AUTH_ERROR(32),
        ACCESS_ERROR(36),
        NOT_INITIALIZED(37),
        INTERNAL_SERVER_ERROR(132),
        TEMPORARY_FAILURE(134),
        SERVER_BUSY(133),
        UNKNOWN_COMMAND(129),
        OUT_OF_MEMORY(130),
        NOT_SUPPORTED(131),
        SUBDOC_PATH_NOT_FOUND(192),
        SUBDOC_PATH_MISMATCH(193),
        SUBDOC_PATH_INVALID(194),
        SUBDOC_PATH_TOO_BIG(195),
        SUBDOC_DOC_TOO_DEEP(196),
        SUBDOC_VALUE_CANTINSERT(197),
        SUBDOC_DOC_NOT_JSON(198),
        SUBDOC_NUM_RANGE(199),
        SUBDOC_DELTA_RANGE(200),
        SUBDOC_PATH_EXISTS(201),
        SUBDOC_VALUE_TOO_DEEP(202),
        SUBDOC_INVALID_COMBO(203),
        SUBDOC_MULTI_PATH_FAILURE(204),
        SUBDOC_XATTR_INVALID_FLAG_COMBO(206),
        SUBDOC_XATTR_INVALID_KEY_COMBO(207),
        SUBDOC_XATTR_UNKNOWN_MACRO(208),
        SUBDOC_XATTR_UNKNOWN_VATTR(209),
        SUBDOC_XATTR_CANNOT_MODIFY_VATTR(210),
        SUBDOC_SUCCESS_DELETED_DOCUMENT(205),
        SUBDOC_MULTI_PATH_FAILURE_DELETED(211),
        SUBDOC_INVALID_XATTR_ORDER(212),
        DURABILITY_INVALID_LEVEL(160),
        DURABILITY_IMPOSSIBLE(161),
        SYNC_WRITE_IN_PROGRESS(162),
        SYNC_WRITE_RE_COMMIT_IN_PROGRESS(164),
        SYNC_WRITE_AMBIGUOUS(163),
        UNKNOWN_COLLECTION(136);

        private final short status;

        private Status(short status) {
            this.status = status;
        }

        public short status() {
            return this.status;
        }
    }

    public static enum Opcode {
        GET(0),
        SET(1),
        ADD(2),
        REPLACE(3),
        DELETE(4),
        INCREMENT(5),
        DECREMENT(6),
        NOOP(10),
        APPEND(14),
        PREPEND(15),
        HELLO(31),
        ERROR_MAP(-2),
        SELECT_BUCKET(-119),
        SASL_LIST_MECHS(32),
        SASL_AUTH(33),
        SASL_STEP(34),
        GET_CONFIG(-75),
        COLLECTIONS_GET_CID(-69),
        SUBDOC_MULTI_LOOKUP(-48),
        SUBDOC_MULTI_MUTATE(-47),
        GET_AND_TOUCH(29),
        GET_AND_LOCK(-108),
        OBSERVE_CAS(-110),
        OBSERVE_SEQ(-111),
        GET_REPLICA(-125),
        TOUCH(28),
        UNLOCK(-107),
        DELETE_WITH_META(-88),
        COLLECTIONS_GET_MANIFEST(-70),
        GET_META(-96);

        private final byte opcode;

        private Opcode(byte opcode) {
            this.opcode = opcode;
        }

        public byte opcode() {
            return this.opcode;
        }
    }

    public static enum Magic {
        REQUEST(-128),
        RESPONSE(-127),
        FLEXIBLE_REQUEST(8),
        FLEXIBLE_RESPONSE(24);

        private final byte magic;

        private Magic(byte magic) {
            this.magic = magic;
        }

        public byte magic() {
            return this.magic;
        }

        public static Magic of(byte input) {
            switch (input) {
                case -128: {
                    return REQUEST;
                }
                case -127: {
                    return RESPONSE;
                }
                case 8: {
                    return FLEXIBLE_REQUEST;
                }
                case 24: {
                    return FLEXIBLE_RESPONSE;
                }
            }
            return null;
        }

        public boolean isFlexible() {
            return this == FLEXIBLE_REQUEST || this == FLEXIBLE_RESPONSE;
        }

        public boolean isRequest() {
            return this == REQUEST || this == FLEXIBLE_REQUEST;
        }
    }
}

