/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.request.RequestNotRetriedEvent;
import com.couchbase.client.core.cnc.events.request.RequestRetryScheduledEvent;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.retry.RetryReason;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public class RetryOrchestrator {
    public static void maybeRetry(CoreContext ctx, Request<? extends Response> request, RetryReason reason) {
        if (request.completed()) {
            return;
        }
        if (reason.alwaysRetry()) {
            RetryOrchestrator.retryWithDuration(ctx, request, RetryOrchestrator.controlledBackoff(request.context().retryAttempts()), reason);
            return;
        }
        request.retryStrategy().shouldRetry(request, reason).whenComplete((retryAction, throwable) -> {
            Optional<Duration> duration;
            if (throwable != null) {
                ctx.environment().eventBus().publish(new RequestNotRetriedEvent((Class<? extends Request>)request.getClass(), request.context(), reason, (Throwable)throwable));
            }
            if ((duration = retryAction.duration()).isPresent()) {
                Duration cappedDuration = RetryOrchestrator.capDuration(duration.get(), request);
                RetryOrchestrator.retryWithDuration(ctx, request, cappedDuration, reason);
            } else {
                ctx.environment().eventBus().publish(new RequestNotRetriedEvent(request.getClass(), request.context(), reason, null));
                request.cancel(CancellationReason.noMoreRetries(reason));
            }
        });
    }

    private static Duration capDuration(Duration uncappedDuration, Request<? extends Response> request) {
        long absoluteTimeout;
        long theoreticalTimeout = System.nanoTime() + uncappedDuration.toNanos();
        long timeoutDelta = theoreticalTimeout - (absoluteTimeout = request.absoluteTimeout());
        if (timeoutDelta > 0L) {
            Duration cappedDuration = uncappedDuration.minus(Duration.ofNanos(timeoutDelta));
            if (cappedDuration.isNegative()) {
                return uncappedDuration;
            }
            return cappedDuration;
        }
        return uncappedDuration;
    }

    private static Duration controlledBackoff(int retryAttempt) {
        switch (retryAttempt) {
            case 0: {
                return Duration.ofMillis(1L);
            }
            case 1: {
                return Duration.ofMillis(10L);
            }
            case 2: {
                return Duration.ofMillis(50L);
            }
            case 3: {
                return Duration.ofMillis(100L);
            }
            case 4: {
                return Duration.ofMillis(500L);
            }
        }
        return Duration.ofMillis(1000L);
    }

    private static void retryWithDuration(CoreContext ctx, Request<? extends Response> request, Duration duration, RetryReason reason) {
        ctx.environment().eventBus().publish(new RequestRetryScheduledEvent(duration, request.context(), request.getClass(), reason));
        request.context().incrementRetryAttempts(duration, reason);
        ctx.environment().timer().scheduleForRetry(ctx.core(), request, duration);
    }
}

