/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.view;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ViewNotFoundException;
import com.couchbase.client.core.error.context.ViewErrorContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.io.netty.chunk.BaseChunkResponseParser;
import com.couchbase.client.core.json.stream.JsonStreamParser;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.view.ViewChunkHeader;
import com.couchbase.client.core.msg.view.ViewChunkRow;
import com.couchbase.client.core.msg.view.ViewChunkTrailer;
import com.couchbase.client.core.msg.view.ViewError;
import java.util.Optional;

public class ViewChunkResponseParser
extends BaseChunkResponseParser<ViewChunkHeader, ViewChunkRow, ViewChunkTrailer> {
    private Long totalRows;
    private Optional<byte[]> debug;
    private Optional<ViewError> error;
    private final JsonStreamParser.Builder parserBuilder = JsonStreamParser.builder().doOnValue("/total_rows", v -> {
        this.totalRows = v.readLong();
    }).doOnValue("/rows/-", v -> this.emitRow(new ViewChunkRow(v.readBytes()))).doOnValue("/debug_info", v -> {
        this.debug = Optional.of(v.readBytes());
    }).doOnValue("/error", v -> {
        String data = v.readString();
        ViewError current = this.error.orElse(new ViewError(null, null));
        this.error = Optional.of(new ViewError(data, current.reason()));
    }).doOnValue("/reason", v -> {
        String data = v.readString();
        ViewError current = this.error.orElse(new ViewError(null, null));
        this.error = Optional.of(new ViewError(current.error(), data));
    });

    @Override
    protected JsonStreamParser.Builder parserBuilder() {
        return this.parserBuilder;
    }

    @Override
    protected void doCleanup() {
        this.totalRows = null;
        this.debug = Optional.empty();
        this.error = Optional.empty();
    }

    @Override
    public Optional<ViewChunkHeader> header() {
        return this.totalRows != null ? Optional.of(new ViewChunkHeader(this.totalRows, this.debug)) : Optional.empty();
    }

    @Override
    public Optional<CouchbaseException> error() {
        return this.error.map(e -> {
            int httpStatus = this.responseHeader().status().code();
            ResponseStatus responseStatus = HttpProtocol.decodeStatus(this.responseHeader().status());
            ViewErrorContext errorContext = new ViewErrorContext(responseStatus, this.requestContext(), (ViewError)e, httpStatus);
            if (responseStatus == ResponseStatus.NOT_FOUND || e.error().equals("not_found") || e.reason().contains("not_found")) {
                return new ViewNotFoundException(errorContext);
            }
            return new CouchbaseException("Unknown view error: " + e.toString(), errorContext);
        });
    }

    @Override
    public void signalComplete() {
        Optional<CouchbaseException> maybeError = this.error();
        if (maybeError.isPresent()) {
            this.failRows(maybeError.get());
        } else {
            this.completeRows();
        }
        this.completeTrailer(new ViewChunkTrailer(this.error));
    }
}

