/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;

public class SecurityConfig {
    private static final boolean DEFAULT_NATIVE_TLS_ENABLED = true;
    private final boolean nativeTlsEnabled;
    private final boolean tlsEnabled;
    private final List<X509Certificate> trustCertificates;
    private final TrustManagerFactory trustManagerFactory;

    public static Builder builder() {
        return new Builder();
    }

    public static SecurityConfig create() {
        return new SecurityConfig(SecurityConfig.builder());
    }

    public static Builder enableTls(boolean tlsEnabled) {
        return SecurityConfig.builder().enableTls(tlsEnabled);
    }

    public static Builder enableNativeTls(boolean nativeTlsEnabled) {
        return SecurityConfig.builder().enableNativeTls(nativeTlsEnabled);
    }

    public static Builder trustCertificates(List<X509Certificate> certificates) {
        return SecurityConfig.builder().trustCertificates(certificates);
    }

    public static Builder trustCertificate(Path certificatePath) {
        return SecurityConfig.builder().trustCertificate(certificatePath);
    }

    public static Builder trustManagerFactory(TrustManagerFactory trustManagerFactory) {
        return SecurityConfig.builder().trustManagerFactory(trustManagerFactory);
    }

    private SecurityConfig(Builder builder) {
        this.tlsEnabled = builder.tlsEnabled;
        this.nativeTlsEnabled = builder.nativeTlsEnabled;
        this.trustCertificates = builder.trustCertificates;
        this.trustManagerFactory = builder.trustManagerFactory;
        if (this.tlsEnabled) {
            if (this.trustCertificates != null && this.trustManagerFactory != null) {
                throw InvalidArgumentException.fromMessage("Either trust certificates or a trust manager factory can be provided, but not both!");
            }
            if ((this.trustCertificates == null || this.trustCertificates.isEmpty()) && this.trustManagerFactory == null) {
                throw InvalidArgumentException.fromMessage("Either a trust certificate or a trust manager factory must be provided when TLS is enabled!");
            }
        }
    }

    public boolean tlsEnabled() {
        return this.tlsEnabled;
    }

    public List<X509Certificate> trustCertificates() {
        return this.trustCertificates;
    }

    public TrustManagerFactory trustManagerFactory() {
        return this.trustManagerFactory;
    }

    public boolean nativeTlsEnabled() {
        return this.nativeTlsEnabled;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("tlsEnabled", this.tlsEnabled);
        export.put("nativeTlsEnabled", this.nativeTlsEnabled);
        export.put("hasTrustCertificates", this.trustCertificates != null && !this.trustCertificates.isEmpty());
        export.put("trustManagerFactory", this.trustManagerFactory != null ? this.trustManagerFactory.getClass().getSimpleName() : null);
        return export;
    }

    public static List<X509Certificate> decodeCertificates(List<String> certificates) {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw InvalidArgumentException.fromMessage("Could not instantiate X.509 CertificateFactory", e);
        }
        return certificates.stream().map(c -> {
            try {
                return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(c.getBytes(StandardCharsets.UTF_8)));
            }
            catch (CertificateException e) {
                throw InvalidArgumentException.fromMessage("Could not generate certificate from raw input: \"" + c + "\"", e);
            }
        }).collect(Collectors.toList());
    }

    public static class Builder {
        private boolean tlsEnabled = false;
        private boolean nativeTlsEnabled = true;
        private List<X509Certificate> trustCertificates = null;
        private TrustManagerFactory trustManagerFactory = null;

        public SecurityConfig build() {
            return new SecurityConfig(this);
        }

        public Builder enableTls(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public Builder enableNativeTls(boolean nativeTlsEnabled) {
            this.nativeTlsEnabled = nativeTlsEnabled;
            return this;
        }

        public Builder trustCertificates(List<X509Certificate> certificates) {
            this.trustCertificates = certificates;
            return this;
        }

        public Builder trustCertificate(Path certificatePath) {
            StringBuilder contentBuilder = new StringBuilder();
            try {
                Files.lines(certificatePath, StandardCharsets.UTF_8).forEach(s -> contentBuilder.append((String)s).append("\n"));
            }
            catch (IOException ex) {
                throw InvalidArgumentException.fromMessage("Could not read trust certificate from file \"" + certificatePath + "\"", ex);
            }
            return this.trustCertificates(SecurityConfig.decodeCertificates(Collections.singletonList(contentBuilder.toString())));
        }

        public Builder trustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = trustManagerFactory;
            return this;
        }
    }
}

