/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.core;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;

public class InitGlobalConfigFailedEvent
extends AbstractEvent {
    private final Reason reason;
    private final Throwable cause;

    public InitGlobalConfigFailedEvent(Event.Severity severity, Duration duration, CoreContext context, Reason reason, Throwable cause) {
        super(severity, Event.Category.CORE, duration, (Context)context);
        this.reason = reason;
        this.cause = reason == Reason.UNSUPPORTED || reason == Reason.SHUTDOWN ? null : cause;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public String description() {
        return "Initializing the global config failed: " + (Object)((Object)this.reason);
    }

    public static enum Reason {
        UNSUPPORTED(Event.Severity.DEBUG),
        NO_CONFIG_FOUND(Event.Severity.WARN),
        UNKNOWN(Event.Severity.WARN),
        SHUTDOWN(Event.Severity.DEBUG);

        private final Event.Severity severity;

        private Reason(Event.Severity severity) {
            this.severity = severity;
        }

        public Event.Severity severity() {
            return this.severity;
        }
    }
}

