/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.io.SelectBucketCompletedEvent;
import com.couchbase.client.core.cnc.events.io.SelectBucketDisabledEvent;
import com.couchbase.client.core.cnc.events.io.SelectBucketFailedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.KeyValueIoErrorContext;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.kv.ChannelAttributes;
import com.couchbase.client.core.io.netty.kv.ConnectTimings;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.io.netty.kv.ServerFeature;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Stability.Internal
public class SelectBucketHandler
extends ChannelDuplexHandler {
    private final EndpointContext endpointContext;
    private final Duration timeout;
    private final String bucketName;
    private IoContext ioContext;
    private ChannelPromise interceptedConnectPromise;

    public SelectBucketHandler(EndpointContext endpointContext, String bucketName) {
        this.endpointContext = endpointContext;
        this.timeout = endpointContext.environment().timeoutConfig().connectTimeout();
        this.bucketName = bucketName;
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        this.interceptedConnectPromise = promise;
        ChannelPromise downstream = ctx.newPromise();
        downstream.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (!f.isSuccess() && !this.interceptedConnectPromise.isDone()) {
                ConnectTimings.record(ctx.channel(), this.getClass());
                this.interceptedConnectPromise.tryFailure(f.cause());
            }
        }));
        ctx.connect(remoteAddress, localAddress, downstream);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        if (this.selectBucketEnabled(ctx)) {
            ctx.executor().schedule(() -> {
                if (!this.interceptedConnectPromise.isDone()) {
                    ConnectTimings.stop(ctx.channel(), this.getClass(), true);
                    this.interceptedConnectPromise.tryFailure(new TimeoutException("KV Select Bucket loading timed out after " + this.timeout.toMillis() + "ms"));
                }
            }, this.timeout.toNanos(), TimeUnit.NANOSECONDS);
            ConnectTimings.start(ctx.channel(), this.getClass());
            ctx.writeAndFlush(this.buildSelectBucketRequest(ctx));
        } else {
            this.endpointContext.environment().eventBus().publish(new SelectBucketDisabledEvent(this.ioContext, this.bucketName));
            ConnectTimings.record(ctx.channel(), this.getClass());
            this.interceptedConnectPromise.trySuccess();
            ctx.pipeline().remove(this);
            ctx.fireChannelActive();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Optional<Duration> latency = ConnectTimings.stop(ctx.channel(), this.getClass(), false);
        if (msg instanceof ByteBuf) {
            short status = MemcacheProtocol.status((ByteBuf)msg);
            if (status == MemcacheProtocol.Status.SUCCESS.status()) {
                this.endpointContext.environment().eventBus().publish(new SelectBucketCompletedEvent(latency.orElse(Duration.ZERO), this.ioContext, this.bucketName));
                this.interceptedConnectPromise.trySuccess();
                ctx.pipeline().remove(this);
                ctx.fireChannelActive();
            } else if (status == MemcacheProtocol.Status.ACCESS_ERROR.status()) {
                this.endpointContext.environment().eventBus().publish(new SelectBucketFailedEvent(this.ioContext, status));
                this.interceptedConnectPromise.tryFailure(new AuthenticationFailureException("No Access to bucket " + RedactableArgument.redactMeta(this.bucketName), new KeyValueIoErrorContext(MemcacheProtocol.decodeStatus(status), this.endpointContext), null));
            } else {
                this.endpointContext.environment().eventBus().publish(new SelectBucketFailedEvent(this.ioContext, status));
                this.interceptedConnectPromise.tryFailure(new CouchbaseException("Select bucket failed with unexpected status code 0x" + Integer.toHexString(status)));
            }
        } else {
            this.interceptedConnectPromise.tryFailure(new CouchbaseException("Unexpected response type on channel read, this is a bug - please report." + msg));
        }
        ReferenceCountUtil.release(msg);
    }

    private ByteBuf buildSelectBucketRequest(ChannelHandlerContext ctx) {
        ByteBuf key = Unpooled.copiedBuffer(this.bucketName, StandardCharsets.UTF_8);
        ByteBuf request = MemcacheProtocol.request(ctx.alloc(), MemcacheProtocol.Opcode.SELECT_BUCKET, MemcacheProtocol.noDatatype(), MemcacheProtocol.noPartition(), BaseKeyValueRequest.nextOpaque(), MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), key, MemcacheProtocol.noBody());
        key.release();
        return request;
    }

    private boolean selectBucketEnabled(ChannelHandlerContext ctx) {
        List<ServerFeature> features = ctx.channel().attr(ChannelAttributes.SERVER_FEATURE_KEY).get();
        return features != null && features.contains((Object)ServerFeature.SELECT_BUCKET);
    }
}

