/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.deps.io.netty.handler.ssl.SslContextBuilder;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;

public class CertificateAuthenticator
implements Authenticator {
    private final PrivateKey key;
    private final String keyPassword;
    private final List<X509Certificate> keyCertChain;
    private final Supplier<KeyManagerFactory> keyManagerFactory;

    public static CertificateAuthenticator fromKeyManagerFactory(Supplier<KeyManagerFactory> keyManagerFactory) {
        Validators.notNull(keyManagerFactory, "KeyManagerFactory");
        return new CertificateAuthenticator(null, null, null, keyManagerFactory);
    }

    public static CertificateAuthenticator fromKey(PrivateKey key, String keyPassword, List<X509Certificate> keyCertChain) {
        Validators.notNull(key, "PrivateKey");
        return new CertificateAuthenticator(key, keyPassword, keyCertChain, null);
    }

    private CertificateAuthenticator(PrivateKey key, String keyPassword, List<X509Certificate> keyCertChain, Supplier<KeyManagerFactory> keyManagerFactory) {
        this.key = key;
        this.keyPassword = keyPassword;
        this.keyCertChain = keyCertChain;
        this.keyManagerFactory = keyManagerFactory;
        if (key != null && keyManagerFactory != null) {
            throw InvalidArgumentException.fromMessage("Either a key certificate or a key manager factory can be provided, but not both!");
        }
    }

    @Override
    public void applyTlsProperties(SslContextBuilder context) {
        if (this.keyManagerFactory != null) {
            context.keyManager(this.keyManagerFactory.get());
        } else if (this.key != null) {
            context.keyManager(this.key, this.keyPassword, this.keyCertChain.toArray(new X509Certificate[0]));
        }
    }

    @Override
    public boolean supportsNonTls() {
        return false;
    }

    public String toString() {
        return "CertificateAuthenticator{key=" + this.key + ", keyPassword='" + this.keyPassword + '\'' + ", keyCertChain=" + this.keyCertChain + ", keyManagerFactory=" + this.keyManagerFactory + '}';
    }
}

