/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.channel.ChannelFutureListener;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.couchbase.client.core.deps.io.netty.handler.codec.CorruptedFrameException;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.Utf8Validator;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class Utf8FrameValidator
extends ChannelInboundHandlerAdapter {
    private int fragmentedFramesCount;
    private Utf8Validator utf8Validator;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (((WebSocketFrame)msg).isFinalFragment()) {
                if (!(frame instanceof PingWebSocketFrame)) {
                    this.fragmentedFramesCount = 0;
                    if (frame instanceof TextWebSocketFrame || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                        this.checkUTF8String(frame.content());
                        this.utf8Validator.finish();
                    }
                }
            } else {
                if (this.fragmentedFramesCount == 0) {
                    if (frame instanceof TextWebSocketFrame) {
                        this.checkUTF8String(frame.content());
                    }
                } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                    this.checkUTF8String(frame.content());
                }
                ++this.fragmentedFramesCount;
            }
        }
        super.channelRead(ctx, msg);
    }

    private void checkUTF8String(ByteBuf buffer) {
        if (this.utf8Validator == null) {
            this.utf8Validator = new Utf8Validator();
        }
        this.utf8Validator.check(buffer);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof CorruptedFrameException && ctx.channel().isOpen()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
        super.exceptionCaught(ctx, cause);
    }
}

