/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.core;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;

public class DnsSrvLookupFailedEvent
extends AbstractEvent {
    private final Throwable cause;
    private final Reason reason;

    public DnsSrvLookupFailedEvent(Event.Severity severity, Duration duration, Throwable cause, Reason reason) {
        super(severity, Event.Category.CORE, duration, null);
        this.cause = cause;
        this.reason = reason;
    }

    @Override
    public String description() {
        String cause = "";
        if (this.cause != null) {
            cause = " (" + this.cause.getMessage() + ")";
        } else if (this.reason != null) {
            cause = " (" + this.reason.identifier() + ")";
        }
        return "DNS SRV lookup failed" + cause + ", trying to bootstrap from given hostname directly.";
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    public Reason reason() {
        return this.reason;
    }

    public static enum Reason {
        NAME_NOT_FOUND("name not found"),
        OTHER("other");

        private final String identifier;

        private Reason(String identifier) {
            this.identifier = identifier;
        }

        public String identifier() {
            return this.identifier;
        }
    }
}

