/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.query;

import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.PrelocatedRequest;
import com.couchbase.client.core.message.query.QueryRequest;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.InetAddress;

public class GenericQueryRequest
extends AbstractCouchbaseRequest
implements QueryRequest,
PrelocatedRequest {
    private static final RedactionLevel REDACTION_LEVEL = CouchbaseLoggerFactory.getRedactionLevel();
    private final String query;
    private final boolean jsonFormat;
    private final InetAddress targetNode;
    private final String contextId;
    private final String statement;

    protected GenericQueryRequest(String query, boolean jsonFormat, String bucket, String username, String password, InetAddress targetNode, String contextId, String statement) {
        super(bucket, username, password);
        this.query = query;
        this.jsonFormat = jsonFormat;
        this.targetNode = targetNode;
        this.contextId = contextId;
        this.statement = statement;
    }

    @Override
    protected void afterSpanSet(Span span) {
        span.setTag(Tags.PEER_SERVICE.getKey(), "n1ql");
        if (this.statement != null && !this.statement.isEmpty() && REDACTION_LEVEL == RedactionLevel.NONE) {
            span.setTag(Tags.DB_STATEMENT.getKey(), this.statement);
        }
    }

    @Override
    public String operationId() {
        return this.contextId;
    }

    public String query() {
        return this.query;
    }

    public boolean isJsonFormat() {
        return this.jsonFormat;
    }

    @Override
    public InetAddress sendTo() {
        return this.targetNode;
    }

    public static GenericQueryRequest simpleStatement(String statement, String bucket, String password) {
        return new GenericQueryRequest(statement, false, bucket, bucket, password, null, null, null);
    }

    public static GenericQueryRequest simpleStatement(String statement, String bucket, String username, String password) {
        return new GenericQueryRequest(statement, false, bucket, username, password, null, null, null);
    }

    public static GenericQueryRequest jsonQuery(String jsonQuery, String bucket, String password, String contextId) {
        return new GenericQueryRequest(jsonQuery, true, bucket, bucket, password, null, contextId, null);
    }

    public static GenericQueryRequest jsonQuery(String jsonQuery, String bucket, String username, String password, String contextId, String statement) {
        return new GenericQueryRequest(jsonQuery, true, bucket, username, password, null, contextId, statement);
    }

    public static GenericQueryRequest jsonQuery(String jsonQuery, String bucket, String password, InetAddress targetNode, String contextId) {
        return new GenericQueryRequest(jsonQuery, true, bucket, bucket, password, targetNode, contextId, null);
    }

    public static GenericQueryRequest jsonQuery(String jsonQuery, String bucket, String username, String password, InetAddress targetNode, String contextId, String statement) {
        return new GenericQueryRequest(jsonQuery, true, bucket, username, password, targetNode, contextId, statement);
    }
}

