/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils;

import com.couchbase.client.core.CouchbaseException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionString {
    public static final String DEFAULT_SCHEME = "couchbase://";
    private final Scheme scheme;
    private final List<InetSocketAddress> hosts;
    private final Map<String, String> params;
    private final String username;

    protected ConnectionString(String input) {
        this.scheme = ConnectionString.parseScheme(input);
        this.username = ConnectionString.parseUser(input);
        this.hosts = ConnectionString.parseHosts(input);
        this.params = ConnectionString.parseParams(input);
    }

    public static ConnectionString create(String input) {
        return new ConnectionString(input);
    }

    public static ConnectionString fromHostnames(List<String> hostnames) {
        StringBuilder sb = new StringBuilder(DEFAULT_SCHEME);
        for (int i = 0; i < hostnames.size(); ++i) {
            sb.append(hostnames.get(i));
            if (i >= hostnames.size() - 1) continue;
            sb.append(",");
        }
        return ConnectionString.create(sb.toString());
    }

    static Scheme parseScheme(String input) {
        if (input.startsWith(DEFAULT_SCHEME)) {
            return Scheme.COUCHBASE;
        }
        if (input.startsWith("couchbases://")) {
            return Scheme.COUCHBASES;
        }
        if (input.startsWith("http://")) {
            return Scheme.HTTP;
        }
        throw new CouchbaseException("Could not parse Scheme of connection string: " + input);
    }

    static String parseUser(String input) {
        if (!input.contains("@")) {
            return null;
        }
        String schemeRemoved = input.replaceAll("\\w+://", "");
        String username = schemeRemoved.replaceAll("@.*", "");
        return username;
    }

    static List<InetSocketAddress> parseHosts(String input) {
        String schemeRemoved = input.replaceAll("\\w+://", "");
        String usernameRemoved = schemeRemoved.replaceAll(".*@", "");
        String paramsRemoved = usernameRemoved.replaceAll("\\?.*", "");
        String[] splitted = paramsRemoved.split(",");
        ArrayList<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
        Pattern ipv6pattern = Pattern.compile("^\\[(.+)]:(\\d+)$");
        for (int i = 0; i < splitted.length; ++i) {
            String singleHost = splitted[i];
            if (singleHost == null || singleHost.isEmpty()) continue;
            singleHost = singleHost.trim();
            Matcher matcher = ipv6pattern.matcher(singleHost);
            if (singleHost.startsWith("[") && singleHost.endsWith("]")) {
                singleHost = singleHost.substring(1, singleHost.length() - 1);
                hosts.add(new InetSocketAddress(singleHost, 0));
                continue;
            }
            if (matcher.matches()) {
                hosts.add(new InetSocketAddress(matcher.group(1), Integer.parseInt(matcher.group(2))));
                continue;
            }
            String[] parts = singleHost.split(":");
            if (parts.length == 1) {
                hosts.add(new InetSocketAddress(parts[0], 0));
                continue;
            }
            hosts.add(new InetSocketAddress(parts[0], Integer.parseInt(parts[1])));
        }
        return hosts;
    }

    static Map<String, String> parseParams(String input) {
        try {
            String[] parts = input.split("\\?");
            HashMap<String, String> params = new HashMap<String, String>();
            if (parts.length > 1) {
                String found = parts[1];
                String[] exploded = found.split("&");
                for (int i = 0; i < exploded.length; ++i) {
                    String[] pair = exploded[i].split("=");
                    params.put(pair[0], pair[1]);
                }
            }
            return params;
        }
        catch (Exception ex) {
            throw new CouchbaseException("Could not parse Params of connection string: " + input, ex);
        }
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public String username() {
        return this.username;
    }

    public List<InetSocketAddress> hosts() {
        return this.hosts;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectionString{");
        sb.append("scheme=").append((Object)this.scheme);
        sb.append(", user=").append(this.username);
        sb.append(", hosts=").append(this.hosts);
        sb.append(", params=").append(this.params);
        sb.append('}');
        return sb.toString();
    }

    public static enum Scheme {
        HTTP,
        COUCHBASE,
        COUCHBASES;

    }
}

