/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.endpoint.SSLException;
import com.couchbase.client.core.env.SecureEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;

public class SSLEngineFactory {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(SSLEngineFactory.class);
    private final SecureEnvironment env;

    public SSLEngineFactory(SecureEnvironment env) {
        this.env = env;
    }

    public SSLEngine get() {
        try {
            String tsFile;
            KeyStore ts;
            String ksFile;
            String pass = this.env.sslKeystorePassword();
            char[] password = pass == null || pass.isEmpty() ? null : pass.toCharArray();
            KeyStore ks = this.env.sslKeystore();
            if (ks == null && (ksFile = this.env.sslKeystoreFile()) != null && !ksFile.isEmpty()) {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(new FileInputStream(ksFile), password);
            }
            if ((ts = this.env.sslTruststore()) == null && (tsFile = this.env.sslTruststoreFile()) != null && !tsFile.isEmpty()) {
                String tsPassword = this.env.sslTruststorePassword();
                char[] tspass = tsPassword == null || tsPassword.isEmpty() ? null : tsPassword.toCharArray();
                ts = KeyStore.getInstance(KeyStore.getDefaultType());
                ts.load(new FileInputStream(tsFile), tspass);
            }
            if (ks == null && ts == null) {
                throw new IllegalStateException("Either a KeyStore or a TrustStore need to be provided (or both).");
            }
            if (ks == null) {
                ks = ts;
                LOGGER.debug("No KeyStore provided, using provided TrustStore to initialize both factories.");
            } else if (ts == null) {
                ts = ks;
                LOGGER.debug("No TrustStore provided, using provided KeyStore to initialize both factories.");
            }
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(defaultAlgorithm);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(defaultAlgorithm);
            kmf.init(ks, password);
            tmf.init(ts);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLEngine engine = ctx.createSSLEngine();
            engine.setUseClientMode(true);
            return engine;
        }
        catch (Exception ex) {
            throw new SSLException("Could not create SSLEngine.", ex);
        }
    }
}

