/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.jackson.databind.deser.std;

import com.couchbase.client.deps.com.fasterxml.jackson.databind.JavaType;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.JsonDeserializer;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.JsonMappingException;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public abstract class ContainerDeserializerBase<T>
extends StdDeserializer<T> {
    protected ContainerDeserializerBase(JavaType selfType) {
        super(selfType);
    }

    @Override
    public SettableBeanProperty findBackReference(String refName) {
        JsonDeserializer<Object> valueDeser = this.getContentDeserializer();
        if (valueDeser == null) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + refName + "': type: container deserializer of type " + this.getClass().getName() + " returned null for 'getContentDeserializer()'");
        }
        return valueDeser.findBackReference(refName);
    }

    public abstract JavaType getContentType();

    public abstract JsonDeserializer<Object> getContentDeserializer();

    protected void wrapAndThrow(Throwable t, Object ref, String key) throws IOException {
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException && !(t instanceof JsonMappingException)) {
            throw (IOException)t;
        }
        if (key == null) {
            key = "N/A";
        }
        throw JsonMappingException.wrapWithPath(t, ref, key);
    }
}

