/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.NodeInfo;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultClusterConfig
implements ClusterConfig {
    private final Map<String, BucketConfig> bucketConfigs = new ConcurrentHashMap<String, BucketConfig>();

    @Override
    public BucketConfig bucketConfig(String bucketName) {
        return this.bucketConfigs.get(bucketName);
    }

    @Override
    public void setBucketConfig(String bucketName, BucketConfig config) {
        this.bucketConfigs.put(bucketName, config);
    }

    @Override
    public void deleteBucketConfig(String bucketName) {
        this.bucketConfigs.remove(bucketName);
    }

    @Override
    public boolean hasBucket(String bucketName) {
        return this.bucketConfigs.containsKey(bucketName);
    }

    @Override
    public Map<String, BucketConfig> bucketConfigs() {
        return this.bucketConfigs;
    }

    @Override
    public Set<InetAddress> allNodeAddresses() {
        HashSet<InetAddress> nodes = new HashSet<InetAddress>();
        for (BucketConfig bc : this.bucketConfigs().values()) {
            for (NodeInfo ni : bc.nodes()) {
                nodes.add(ni.hostname());
            }
        }
        return nodes;
    }
}

