/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ServiceNotAvailableException;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.service.ServiceType;
import java.util.List;

public class ViewLocator
implements Locator {
    private static final ServiceNotAvailableException NOT_AVAILABLE = new ServiceNotAvailableException("Views are not available on this bucket type.");
    private long counter = 0L;

    @Override
    public Node[] locate(CouchbaseRequest request, List<Node> nodes, ClusterConfig config) {
        Node node;
        int offset;
        int i;
        BucketConfig bucketConfig = config.bucketConfig(request.bucket());
        if (!(bucketConfig instanceof CouchbaseBucketConfig)) {
            request.observable().onError((Throwable)NOT_AVAILABLE);
            return null;
        }
        int nodeSize = nodes.size();
        for (i = offset = (int)this.counter++ % nodeSize; i < nodeSize; ++i) {
            node = nodes.get(i);
            if (!this.checkNode(node, (CouchbaseBucketConfig)bucketConfig)) continue;
            return new Node[]{node};
        }
        for (i = 0; i < offset; ++i) {
            node = nodes.get(i);
            if (!this.checkNode(node, (CouchbaseBucketConfig)bucketConfig)) continue;
            return new Node[]{node};
        }
        return new Node[0];
    }

    protected boolean checkNode(Node node, CouchbaseBucketConfig config) {
        return node.serviceEnabled(ServiceType.VIEW) && config.hasPrimaryPartitionsOnNode(node.hostname());
    }
}

