/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.codec.memcache.binary;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;

public class DefaultFullBinaryMemcacheRequest
extends DefaultBinaryMemcacheRequest
implements FullBinaryMemcacheRequest {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheRequest(String key, ByteBuf extras) {
        this(key, extras, Unpooled.buffer(0));
    }

    public DefaultFullBinaryMemcacheRequest(String key, ByteBuf extras, ByteBuf content) {
        super(key, extras);
        if (content == null) {
            throw new NullPointerException("Supplied content is null.");
        }
        this.content = content;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullBinaryMemcacheRequest retain() {
        super.retain();
        this.content.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest retain(int increment) {
        super.retain(increment);
        this.content.retain(increment);
        return this;
    }

    @Override
    public boolean release() {
        super.release();
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        super.release(decrement);
        return this.content.release(decrement);
    }

    @Override
    public FullBinaryMemcacheRequest copy() {
        ByteBuf extras = this.getExtras();
        if (extras != null) {
            extras = extras.copy();
        }
        return new DefaultFullBinaryMemcacheRequest(this.getKey(), extras, this.content().copy());
    }

    @Override
    public FullBinaryMemcacheRequest duplicate() {
        ByteBuf extras = this.getExtras();
        if (extras != null) {
            extras = extras.duplicate();
        }
        return new DefaultFullBinaryMemcacheRequest(this.getKey(), extras, this.content().duplicate());
    }
}

