/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv;

import com.couchbase.client.core.message.AbstractCouchbaseResponse;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.BinaryResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;

public abstract class AbstractKeyValueResponse
extends AbstractCouchbaseResponse
implements BinaryResponse {
    private final ByteBuf content;
    private final String bucket;

    protected AbstractKeyValueResponse(ResponseStatus status, String bucket, ByteBuf content, CouchbaseRequest request) {
        super(status, request);
        this.content = content == null ? Unpooled.EMPTY_BUFFER : content;
        this.bucket = bucket;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public BinaryResponse retain() {
        this.content.retain();
        return this;
    }

    @Override
    public BinaryResponse retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("BinaryResponse{");
        sb.append("bucket='").append(this.bucket).append('\'');
        sb.append(", status=").append((Object)this.status());
        sb.append(", request=").append(this.request());
        sb.append(", content=").append(this.content);
        sb.append('}');
        return sb.toString();
    }
}

