/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultMemcachedBucketConfig
extends AbstractBucketConfig
implements MemcachedBucketConfig {
    private final long rev;
    private final TreeMap<Long, NodeInfo> ketamaNodes;

    @JsonCreator
    public DefaultMemcachedBucketConfig(@JsonProperty(value="rev") long rev, @JsonProperty(value="name") String name, @JsonProperty(value="nodeLocator") String locator, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos) {
        super(name, BucketNodeLocator.fromConfig(locator), uri, streamingUri, nodeInfos, portInfos);
        this.rev = rev;
        this.ketamaNodes = new TreeMap();
        this.populateKetamaNodes();
    }

    @Override
    public boolean tainted() {
        return false;
    }

    @Override
    public long rev() {
        return this.rev;
    }

    @Override
    public BucketType type() {
        return BucketType.MEMCACHED;
    }

    @Override
    public SortedMap<Long, NodeInfo> ketamaNodes() {
        return this.ketamaNodes;
    }

    private void populateKetamaNodes() {
        for (NodeInfo node : this.nodes()) {
            if (!node.services().containsKey((Object)ServiceType.BINARY)) continue;
            for (int i = 0; i < 40; ++i) {
                try {
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    md5.update(this.keyForNode(node.hostname(), i).getBytes(CharsetUtil.UTF_8));
                    byte[] digest = md5.digest();
                    for (int j = 0; j < 4; ++j) {
                        Long key = (long)(digest[3 + j * 4] & 0xFF) << 24 | (long)(digest[2 + j * 4] & 0xFF) << 16 | (long)(digest[1 + j * 4] & 0xFF) << 8 | (long)(digest[j * 4] & 0xFF);
                        this.ketamaNodes.put(key, node);
                    }
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Could not populate ketama nodes.", e);
                }
            }
        }
    }

    private String keyForNode(InetAddress hostname, int repetition) {
        return hostname.getHostName() + "-" + repetition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMemcachedBucketConfig{");
        sb.append("rev=").append(this.rev);
        sb.append(", ketamaNodes=").append(this.ketamaNodes);
        sb.append('}');
        return sb.toString();
    }
}

