/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.DefaultNodeInfo;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.service.ServiceType;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractBucketConfig
implements BucketConfig {
    private final String name;
    private String password;
    private final BucketNodeLocator locator;
    private final String uri;
    private final String streamingUri;
    private final List<NodeInfo> nodeInfo;
    private final Set<ServiceType> enabledServices;

    protected AbstractBucketConfig(String name, BucketNodeLocator locator, String uri, String streamingUri, List<NodeInfo> nodeInfos, List<PortInfo> portInfos) {
        this.name = name;
        this.locator = locator;
        this.uri = uri;
        this.streamingUri = streamingUri;
        this.nodeInfo = portInfos == null ? nodeInfos : AbstractBucketConfig.nodeInfoFromExtended(portInfos, nodeInfos);
        this.enabledServices = new HashSet<ServiceType>();
        for (NodeInfo info : this.nodeInfo) {
            this.enabledServices.addAll(info.services().keySet());
            this.enabledServices.addAll(info.sslServices().keySet());
        }
    }

    private static List<NodeInfo> nodeInfoFromExtended(List<PortInfo> nodesExt, List<NodeInfo> nodeInfos) {
        ArrayList<NodeInfo> converted = new ArrayList<NodeInfo>(nodesExt.size());
        for (int i = 0; i < nodesExt.size(); ++i) {
            InetAddress hostname = nodesExt.get(i).hostname();
            if (hostname == null) {
                hostname = nodeInfos.get(i).hostname();
            }
            converted.add(new DefaultNodeInfo(hostname, nodesExt.get(i).ports(), nodesExt.get(i).sslPorts()));
        }
        return converted;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BucketNodeLocator locator() {
        return this.locator;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String streamingUri() {
        return this.streamingUri;
    }

    @Override
    public List<NodeInfo> nodes() {
        return this.nodeInfo;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public BucketConfig password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public boolean serviceEnabled(ServiceType type) {
        return this.enabledServices.contains((Object)type);
    }
}

