/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class DefaultNodeInfo
implements NodeInfo {
    private final String viewUri;
    private final InetAddress hostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;
    private int configPort;

    @JsonCreator
    public DefaultNodeInfo(@JsonProperty(value="couchApiBase") String viewUri, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports) {
        this.viewUri = viewUri;
        try {
            this.hostname = InetAddress.getByName(this.trimPort(hostname));
        }
        catch (UnknownHostException e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        this.directServices = this.parseDirectServices(ports);
        this.sslServices = new HashMap<ServiceType, Integer>();
    }

    public DefaultNodeInfo(String viewUri, InetAddress hostname, Map<ServiceType, Integer> direct, Map<ServiceType, Integer> ssl) {
        this.viewUri = viewUri;
        this.hostname = hostname;
        this.directServices = direct;
        this.sslServices = ssl;
    }

    @Override
    public String viewUri() {
        return this.viewUri;
    }

    @Override
    public InetAddress hostname() {
        return this.hostname;
    }

    @Override
    public Map<ServiceType, Integer> services() {
        return this.directServices;
    }

    @Override
    public Map<ServiceType, Integer> sslServices() {
        return this.sslServices;
    }

    private Map<ServiceType, Integer> parseDirectServices(Map<String, Integer> input) {
        HashMap<ServiceType, Integer> services = new HashMap<ServiceType, Integer>();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            String type = entry.getKey();
            Integer port = entry.getValue();
            if (!type.equals("direct")) continue;
            services.put(ServiceType.BINARY, port);
        }
        services.put(ServiceType.CONFIG, this.configPort);
        if (this.viewUri != null) {
            services.put(ServiceType.VIEW, URI.create(this.viewUri).getPort());
        }
        return services;
    }

    private String trimPort(String hostname) {
        String[] parts = hostname.split(":");
        this.configPort = Integer.parseInt(parts[1]);
        return parts[0];
    }

    public String toString() {
        return "NodeInfo{viewUri='" + this.viewUri + '\'' + ", hostname=" + this.hostname + ", configPort=" + this.configPort + ", directServices=" + this.directServices + ", sslServices=" + this.sslServices + '}';
    }
}

