/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.view;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.view.GetDesignDocumentRequest;
import com.couchbase.client.core.message.view.GetDesignDocumentResponse;
import com.couchbase.client.core.message.view.RemoveDesignDocumentRequest;
import com.couchbase.client.core.message.view.RemoveDesignDocumentResponse;
import com.couchbase.client.core.message.view.UpsertDesignDocumentRequest;
import com.couchbase.client.core.message.view.UpsertDesignDocumentResponse;
import com.couchbase.client.core.message.view.ViewQueryRequest;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.core.message.view.ViewRequest;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.base64.Base64;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;
import java.util.Queue;
import rx.Observable;
import rx.Scheduler;
import rx.subjects.ReplaySubject;

public class ViewHandler
extends AbstractGenericHandler<HttpObject, HttpRequest, ViewRequest> {
    private static final byte QUERY_STATE_INITIAL = 0;
    private static final byte QUERY_STATE_ROWS = 1;
    private static final byte QUERY_STATE_INFO = 2;
    private static final byte QUERY_STATE_ERROR = 3;
    private static final byte QUERY_STATE_DONE = 4;
    private HttpResponse responseHeader;
    private ByteBuf responseContent;
    private ReplaySubject<ByteBuf> viewRowObservable;
    private ReplaySubject<ByteBuf> viewInfoObservable;
    private byte viewParsingState = 0;

    public ViewHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer) {
        super(endpoint, responseBuffer);
    }

    ViewHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<ViewRequest> queue) {
        super(endpoint, responseBuffer, queue);
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, ViewRequest msg) throws Exception {
        AbstractCouchbaseRequest queryMsg;
        StringBuilder path = new StringBuilder();
        HttpMethod method = HttpMethod.GET;
        ByteBuf content = null;
        if (msg instanceof ViewQueryRequest) {
            queryMsg = (ViewQueryRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((ViewQueryRequest)queryMsg).development() ? "dev_" + ((ViewQueryRequest)queryMsg).design() : ((ViewQueryRequest)queryMsg).design());
            path.append("/_view/").append(((ViewQueryRequest)queryMsg).view());
            if (((ViewQueryRequest)queryMsg).query() != null && !((ViewQueryRequest)queryMsg).query().isEmpty()) {
                path.append("?").append(((ViewQueryRequest)queryMsg).query());
            }
        } else if (msg instanceof GetDesignDocumentRequest) {
            queryMsg = (GetDesignDocumentRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((GetDesignDocumentRequest)queryMsg).development() ? "dev_" + ((GetDesignDocumentRequest)queryMsg).name() : ((GetDesignDocumentRequest)queryMsg).name());
        } else if (msg instanceof UpsertDesignDocumentRequest) {
            method = HttpMethod.PUT;
            queryMsg = (UpsertDesignDocumentRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((UpsertDesignDocumentRequest)queryMsg).development() ? "dev_" + ((UpsertDesignDocumentRequest)queryMsg).name() : ((UpsertDesignDocumentRequest)queryMsg).name());
            content = Unpooled.copiedBuffer(((UpsertDesignDocumentRequest)queryMsg).body(), CHARSET);
        } else if (msg instanceof RemoveDesignDocumentRequest) {
            method = HttpMethod.DELETE;
            queryMsg = (RemoveDesignDocumentRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((RemoveDesignDocumentRequest)queryMsg).development() ? "dev_" + ((RemoveDesignDocumentRequest)queryMsg).name() : ((RemoveDesignDocumentRequest)queryMsg).name());
        } else {
            throw new IllegalArgumentException("Unknown incoming ViewRequest type " + msg.getClass());
        }
        if (content == null) {
            content = Unpooled.buffer(0);
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path.toString(), content);
        request.headers().set("User-Agent", (Object)this.env().userAgent());
        request.headers().set("Content-Length", (Object)content.readableBytes());
        request.headers().set("Content-Type", (Object)"application/json");
        ViewHandler.addAuth(ctx, request, msg.bucket(), msg.password());
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        ViewRequest request = (ViewRequest)this.currentRequest();
        CouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            if (this.currentRequest() instanceof ViewQueryRequest) {
                if (this.viewRowObservable == null) {
                    response = this.handleViewQueryResponse();
                }
                this.parseQueryResponse(msg instanceof LastHttpContent);
            }
        }
        if (msg instanceof LastHttpContent) {
            if (request instanceof GetDesignDocumentRequest) {
                response = this.handleGetDesignDocumentResponse((GetDesignDocumentRequest)request);
                this.finishedDecoding();
            } else if (request instanceof UpsertDesignDocumentRequest) {
                response = this.handleUpsertDesignDocumentResponse((UpsertDesignDocumentRequest)request);
                this.finishedDecoding();
            } else if (request instanceof RemoveDesignDocumentRequest) {
                response = this.handleRemoveDesignDocumentResponse((RemoveDesignDocumentRequest)request);
                this.finishedDecoding();
            }
        }
        return response;
    }

    private CouchbaseResponse handleGetDesignDocumentResponse(GetDesignDocumentRequest request) {
        ResponseStatus status = ViewHandler.statusFromCode(this.responseHeader.getStatus().code());
        return new GetDesignDocumentResponse(request.name(), request.development(), this.responseContent.copy(), status, request);
    }

    private CouchbaseResponse handleUpsertDesignDocumentResponse(UpsertDesignDocumentRequest request) {
        ResponseStatus status = ViewHandler.statusFromCode(this.responseHeader.getStatus().code());
        return new UpsertDesignDocumentResponse(status, this.responseContent.copy(), request);
    }

    private CouchbaseResponse handleRemoveDesignDocumentResponse(RemoveDesignDocumentRequest request) {
        ResponseStatus status = ViewHandler.statusFromCode(this.responseHeader.getStatus().code());
        return new RemoveDesignDocumentResponse(status, this.responseContent.copy(), request);
    }

    private CouchbaseResponse handleViewQueryResponse() {
        int code = this.responseHeader.getStatus().code();
        String phrase = this.responseHeader.getStatus().reasonPhrase();
        ResponseStatus status = ViewHandler.statusFromCode(this.responseHeader.getStatus().code());
        Scheduler scheduler = this.env().scheduler();
        this.viewRowObservable = ReplaySubject.create();
        this.viewInfoObservable = ReplaySubject.create();
        return new ViewQueryResponse((Observable<ByteBuf>)this.viewRowObservable.onBackpressureBuffer().observeOn(scheduler), (Observable<ByteBuf>)this.viewInfoObservable.onBackpressureBuffer().observeOn(scheduler), code, phrase, status, (CouchbaseRequest)this.currentRequest());
    }

    private void parseQueryResponse(boolean last) {
        if (this.viewParsingState == 0) {
            this.parseViewInitial();
        }
        if (this.viewParsingState == 2) {
            this.parseViewInfo();
        }
        if (this.viewParsingState == 3) {
            this.parseViewError(last);
        }
        if (this.viewParsingState == 1) {
            this.parseViewRows(last);
        }
        if (this.viewParsingState == 4) {
            this.cleanupViewStates();
        }
    }

    private void cleanupViewStates() {
        this.finishedDecoding();
        this.viewInfoObservable = null;
        this.viewRowObservable = null;
        this.viewParsingState = 0;
    }

    private void parseViewInitial() {
        switch (this.responseHeader.getStatus().code()) {
            case 200: {
                this.viewParsingState = (byte)2;
                break;
            }
            default: {
                this.viewRowObservable.onCompleted();
                this.viewParsingState = (byte)3;
            }
        }
    }

    private void parseViewError(boolean last) {
        if (!last) {
            return;
        }
        this.viewInfoObservable.onNext((Object)this.responseContent.copy());
        this.viewInfoObservable.onCompleted();
        this.viewParsingState = (byte)4;
    }

    private void parseViewInfo() {
        int rowsStart = -1;
        for (int i = this.responseContent.readerIndex(); i < this.responseContent.writerIndex() - 2; ++i) {
            byte curr = this.responseContent.getByte(i);
            byte f1 = this.responseContent.getByte(i + 1);
            byte f2 = this.responseContent.getByte(i + 2);
            if (curr != 34 || f1 != 114 || f2 != 111) continue;
            rowsStart = i;
            break;
        }
        if (rowsStart == -1) {
            return;
        }
        ByteBuf info = this.responseContent.readBytes(rowsStart - this.responseContent.readerIndex());
        int closingPointer = info.forEachByteDesc(new ByteBufProcessor(){

            @Override
            public boolean process(byte value) throws Exception {
                return value != 44;
            }
        });
        if (closingPointer > 0) {
            info.setByte(closingPointer, 125);
            this.viewInfoObservable.onNext((Object)info);
        } else {
            this.viewInfoObservable.onNext((Object)Unpooled.EMPTY_BUFFER);
        }
        this.viewInfoObservable.onCompleted();
        this.viewParsingState = 1;
    }

    private void parseViewRows(boolean last) {
        while (true) {
            int openBracketPos = this.responseContent.bytesBefore((byte)123);
            int closeBracketPos = -1;
            int openBrackets = 0;
            for (int i = this.responseContent.readerIndex(); i <= this.responseContent.writerIndex(); ++i) {
                byte current = this.responseContent.getByte(i);
                if (current == 123) {
                    ++openBrackets;
                    continue;
                }
                if (current != 125 || openBrackets <= 0 || --openBrackets != 0) continue;
                closeBracketPos = i;
                break;
            }
            if (closeBracketPos == -1) break;
            int from = this.responseContent.readerIndex() + openBracketPos;
            int to = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.viewRowObservable.onNext((Object)this.responseContent.slice(from, to).copy());
            this.responseContent.readerIndex(closeBracketPos);
        }
        this.responseContent.discardReadBytes();
        if (last) {
            this.viewRowObservable.onCompleted();
            this.viewParsingState = (byte)4;
        }
    }

    private static void addAuth(ChannelHandlerContext ctx, HttpRequest request, String user, String password) {
        String pw = password == null ? "" : password;
        ByteBuf raw = ctx.alloc().buffer(user.length() + pw.length() + 1);
        raw.writeBytes((user + ":" + pw).getBytes(CHARSET));
        ByteBuf encoded = Base64.encode(raw);
        request.headers().add("Authorization", (Object)("Basic " + encoded.toString(CHARSET)));
        encoded.release();
        raw.release();
    }

    private static ResponseStatus statusFromCode(int code) {
        ResponseStatus status;
        switch (code) {
            case 200: 
            case 201: {
                status = ResponseStatus.SUCCESS;
                break;
            }
            case 404: {
                status = ResponseStatus.NOT_EXISTS;
                break;
            }
            default: {
                status = ResponseStatus.FAILURE;
            }
        }
        return status;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.viewRowObservable != null) {
            this.viewRowObservable.onCompleted();
        }
        if (this.viewInfoObservable != null) {
            this.viewInfoObservable.onCompleted();
        }
        this.cleanupViewStates();
        super.handlerRemoved(ctx);
    }
}

