/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.AbstractLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.net.InetAddress;
import rx.Observable;
import rx.functions.Func1;

public class CarrierLoader
extends AbstractLoader {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CarrierLoader.class);

    public CarrierLoader(ClusterFacade cluster, CoreEnvironment environment) {
        super(LoaderType.Carrier, ServiceType.BINARY, cluster, environment);
    }

    @Override
    protected int port() {
        return this.env().sslEnabled() ? this.env().bootstrapCarrierSslPort() : this.env().bootstrapCarrierDirectPort();
    }

    @Override
    protected Observable<String> discoverConfig(String bucket, String password, final InetAddress hostname) {
        if (!this.env().bootstrapCarrierEnabled()) {
            LOGGER.info("Carrier Bootstrap manually disabled.");
            return Observable.error((Throwable)new ConfigurationException("Carrier Bootstrap disabled through configuration."));
        }
        LOGGER.debug("Starting to discover config through Carrier Bootstrap");
        return this.cluster().send(new GetBucketConfigRequest(bucket, hostname)).map((Func1)new Func1<GetBucketConfigResponse, String>(){

            public String call(GetBucketConfigResponse response) {
                if (!response.status().isSuccess()) {
                    response.content().release();
                    throw new IllegalStateException("Bucket config response did not return with success.");
                }
                LOGGER.debug("Successfully loaded config through carrier.");
                String content = response.content().toString(CharsetUtil.UTF_8);
                response.content().release();
                return CarrierLoader.this.replaceHostWildcard(content, hostname);
            }
        });
    }
}

