/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ReplicaNotConfiguredException;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.Partition;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ReplicaGetRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.SortedMap;
import java.util.zip.CRC32;

public class KeyValueLocator
implements Locator {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueLocator.class);

    @Override
    public Node[] locate(CouchbaseRequest request, Set<Node> nodes, ClusterConfig cluster) {
        if (request instanceof GetBucketConfigRequest) {
            for (Node node : nodes) {
                if (!node.isState(LifecycleState.CONNECTED) || !((GetBucketConfigRequest)request).hostname().equals(node.hostname())) continue;
                return new Node[]{node};
            }
            return new Node[0];
        }
        BucketConfig bucket = cluster.bucketConfig(request.bucket());
        if (bucket instanceof CouchbaseBucketConfig) {
            return this.locateForCouchbaseBucket((BinaryRequest)request, nodes, (CouchbaseBucketConfig)bucket);
        }
        if (bucket instanceof MemcachedBucketConfig) {
            return this.locateForMemcacheBucket((BinaryRequest)request, nodes, (MemcachedBucketConfig)bucket);
        }
        throw new IllegalStateException("Unsupported Bucket Type: " + bucket + " for request " + request);
    }

    private Node[] locateForCouchbaseBucket(BinaryRequest request, Set<Node> nodes, CouchbaseBucketConfig config) {
        String key = request.key();
        CRC32 crc32 = new CRC32();
        try {
            crc32.update(key.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        long rv = crc32.getValue() >> 16 & 0x7FFFL;
        int partitionId = (int)rv & config.partitions().size() - 1;
        request.partition((short)partitionId);
        Partition partition = config.partitions().get(partitionId);
        short nodeId = request instanceof ReplicaGetRequest ? partition.replica(((ReplicaGetRequest)request).replica() - 1) : (request instanceof ObserveRequest && ((ObserveRequest)request).replica() > 0 ? partition.replica(((ObserveRequest)request).replica() - 1) : partition.master());
        if (nodeId == -2) {
            if (request instanceof ReplicaGetRequest) {
                request.observable().onError((Throwable)new ReplicaNotConfiguredException("Replica number " + ((ReplicaGetRequest)request).replica() + " not configured for bucket " + config.name()));
            } else if (request instanceof ObserveRequest) {
                request.observable().onError((Throwable)new ReplicaNotConfiguredException("Replica number " + ((ObserveRequest)request).replica() + " not configured for bucket " + config.name()));
            }
            return null;
        }
        if (nodeId == -1) {
            return new Node[0];
        }
        NodeInfo nodeInfo = config.partitionHosts().get(nodeId);
        if (config.partitionHosts().size() != nodes.size()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Node list and configuration's partition hosts sizes : {} <> {}, rescheduling", (Object)nodes.size(), (Object)config.partitionHosts().size());
            }
            return new Node[0];
        }
        for (Node node : nodes) {
            if (!node.hostname().equals(nodeInfo.hostname())) continue;
            return new Node[]{node};
        }
        throw new IllegalStateException("Node not found for request" + request);
    }

    private Node[] locateForMemcacheBucket(BinaryRequest request, Set<Node> nodes, MemcachedBucketConfig config) {
        long hash = this.ketamaHash(request.key());
        if (!config.ketamaNodes().containsKey(hash)) {
            SortedMap<Long, NodeInfo> tailMap = config.ketamaNodes().tailMap(hash);
            hash = tailMap.isEmpty() ? config.ketamaNodes().firstKey().longValue() : tailMap.firstKey().longValue();
        }
        NodeInfo found = (NodeInfo)config.ketamaNodes().get(hash);
        request.partition((short)0);
        for (Node node : nodes) {
            if (!node.hostname().equals(found.hostname())) continue;
            return new Node[]{node};
        }
        throw new IllegalStateException("Node not found for request" + request);
    }

    private long ketamaHash(String key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(key.getBytes(CharsetUtil.UTF_8));
            byte[] digest = md5.digest();
            long rv = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
            return rv & 0xFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not encode ketama hash.", e);
        }
    }
}

