/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ResponseHandler;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.RemoveServiceRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.node.DefaultServiceRegistry;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.ServiceRegistry;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceFactory;
import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class CouchbaseNode
extends AbstractStateMachine<LifecycleState>
implements Node {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Node.class);
    private final InetAddress hostname;
    private final CoreEnvironment environment;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final ServiceRegistry serviceRegistry;
    private final Map<Service, LifecycleState> serviceStates;
    private volatile boolean connected;

    public CouchbaseNode(InetAddress hostname, CoreEnvironment environment, RingBuffer<ResponseEvent> responseBuffer) {
        this(hostname, new DefaultServiceRegistry(), environment, responseBuffer);
    }

    CouchbaseNode(InetAddress hostname, ServiceRegistry registry, CoreEnvironment environment, RingBuffer<ResponseEvent> responseBuffer) {
        super(LifecycleState.DISCONNECTED);
        this.hostname = hostname;
        this.serviceRegistry = registry;
        this.environment = environment;
        this.responseBuffer = responseBuffer;
        this.serviceStates = new ConcurrentHashMap<Service, LifecycleState>();
    }

    @Override
    public void send(CouchbaseRequest request) {
        if (request instanceof SignalFlush) {
            for (Service service : this.serviceRegistry.services()) {
                service.send(request);
            }
        } else {
            Service service = this.serviceRegistry.locate(request);
            if (service == null) {
                this.responseBuffer.publishEvent(ResponseHandler.RESPONSE_TRANSLATOR, request, request.observable());
            } else {
                service.send(request);
            }
        }
    }

    @Override
    public InetAddress hostname() {
        return this.hostname;
    }

    @Override
    public Observable<LifecycleState> connect() {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Got instructed to connect.");
        return Observable.from(this.serviceRegistry.services()).flatMap((Func1)new Func1<Service, Observable<LifecycleState>>(){

            public Observable<LifecycleState> call(Service service) {
                LOGGER.debug(CouchbaseNode.logIdent(CouchbaseNode.this.hostname) + "Instructing Service " + (Object)((Object)service.type()) + " to connect.");
                return service.connect();
            }
        }).toList().map((Func1)new Func1<List<LifecycleState>, LifecycleState>(){

            public LifecycleState call(List<LifecycleState> state) {
                return (LifecycleState)((Object)CouchbaseNode.this.state());
            }
        });
    }

    @Override
    public Observable<LifecycleState> disconnect() {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Got instructed to disconnect.");
        return Observable.from(this.serviceRegistry.services()).flatMap((Func1)new Func1<Service, Observable<LifecycleState>>(){

            public Observable<LifecycleState> call(Service service) {
                LOGGER.debug(CouchbaseNode.logIdent(CouchbaseNode.this.hostname) + "Instructing Service " + (Object)((Object)service.type()) + " to disconnect.");
                return service.disconnect();
            }
        }).toList().map((Func1)new Func1<List<LifecycleState>, LifecycleState>(){

            public LifecycleState call(List<LifecycleState> state) {
                return (LifecycleState)((Object)CouchbaseNode.this.state());
            }
        });
    }

    @Override
    public Observable<Service> addService(AddServiceRequest request) {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Adding Service " + (Object)((Object)request.type()));
        Service addedService = this.serviceRegistry.serviceBy(request.type(), request.bucket());
        if (addedService != null) {
            LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Service " + (Object)((Object)request.type()) + " already added, skipping.");
            return Observable.just((Object)addedService);
        }
        final Service service = ServiceFactory.create(request.hostname().getHostName(), request.bucket(), request.password(), request.port(), this.environment, request.type(), this.responseBuffer);
        this.serviceStates.put(service, (LifecycleState)((Object)service.state()));
        service.states().subscribe((Action1)new Action1<LifecycleState>(){

            public void call(LifecycleState state) {
                CouchbaseNode.this.serviceStates.put(service, state);
                LifecycleState oldState = (LifecycleState)((Object)CouchbaseNode.this.state());
                LifecycleState newState = CouchbaseNode.this.recalculateState();
                if (oldState == newState) {
                    return;
                }
                if (newState == LifecycleState.CONNECTED) {
                    if (!CouchbaseNode.this.connected) {
                        LOGGER.info("Connected to Node " + CouchbaseNode.this.hostname.getHostName());
                    }
                    CouchbaseNode.this.connected = true;
                    LOGGER.debug("Connected (" + CouchbaseNode.this.state() + ") to Node " + CouchbaseNode.this.hostname);
                } else if (newState == LifecycleState.DISCONNECTED) {
                    if (CouchbaseNode.this.connected) {
                        LOGGER.info("Disconnected from Node " + CouchbaseNode.this.hostname.getHostName());
                    }
                    CouchbaseNode.this.connected = false;
                    LOGGER.debug("Disconnected (" + CouchbaseNode.this.state() + ") from Node " + CouchbaseNode.this.hostname);
                }
                CouchbaseNode.this.transitionState(newState);
            }
        });
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Adding Service " + (Object)((Object)request.type()) + " to registry and connecting it.");
        this.serviceRegistry.addService(service, request.bucket());
        return service.connect().map((Func1)new Func1<LifecycleState, Service>(){

            public Service call(LifecycleState state) {
                return service;
            }
        });
    }

    @Override
    public Observable<Service> removeService(RemoveServiceRequest request) {
        LOGGER.debug(CouchbaseNode.logIdent(this.hostname) + "Removing Service " + (Object)((Object)request.type()));
        Service service = this.serviceRegistry.serviceBy(request.type(), request.bucket());
        this.serviceRegistry.removeService(service, request.bucket());
        this.serviceStates.remove(service);
        return Observable.just((Object)service);
    }

    private LifecycleState recalculateState() {
        if (this.serviceStates.isEmpty()) {
            return LifecycleState.DISCONNECTED;
        }
        int connected = 0;
        int connecting = 0;
        int disconnecting = 0;
        for (LifecycleState serviceState : this.serviceStates.values()) {
            switch (serviceState) {
                case CONNECTED: {
                    ++connected;
                    break;
                }
                case CONNECTING: {
                    ++connecting;
                    break;
                }
                case DISCONNECTING: {
                    ++disconnecting;
                }
            }
        }
        if (this.serviceStates.size() == connected) {
            return LifecycleState.CONNECTED;
        }
        if (connected > 0) {
            return LifecycleState.DEGRADED;
        }
        if (connecting > 0) {
            return LifecycleState.CONNECTING;
        }
        if (disconnecting > 0) {
            return LifecycleState.DISCONNECTING;
        }
        return LifecycleState.DISCONNECTED;
    }

    public String toString() {
        return "CouchbaseNode{hostname=" + this.hostname + ", services=" + this.serviceRegistry + '}';
    }

    protected static String logIdent(InetAddress hostname) {
        return "[" + hostname.getHostName() + "]: ";
    }
}

