/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.NewThreadWorker;
import rx.internal.schedulers.ScheduledAction;
import rx.internal.util.RxThreadFactory;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class CoreScheduler
extends Scheduler {
    private static final String THREAD_NAME_PREFIX = "cb-computations-";
    private static final RxThreadFactory THREAD_FACTORY = new RxThreadFactory("cb-computations-");
    final FixedSchedulerPool pool;

    public CoreScheduler(int poolSize) {
        this.pool = new FixedSchedulerPool(poolSize);
    }

    public Scheduler.Worker createWorker() {
        return new EventLoopWorker(this.pool.getEventLoop());
    }

    private static final class PoolWorker
    extends NewThreadWorker {
        PoolWorker(ThreadFactory threadFactory) {
            super(threadFactory);
        }
    }

    private static class EventLoopWorker
    extends Scheduler.Worker {
        private final CompositeSubscription innerSubscription = new CompositeSubscription();
        private final PoolWorker poolWorker;

        EventLoopWorker(PoolWorker poolWorker) {
            this.poolWorker = poolWorker;
        }

        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, null);
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            if (this.innerSubscription.isUnsubscribed()) {
                return Subscriptions.empty();
            }
            ScheduledAction s = this.poolWorker.scheduleActual(action, delayTime, unit);
            this.innerSubscription.add((Subscription)s);
            s.addParent(this.innerSubscription);
            return s;
        }
    }

    static final class FixedSchedulerPool {
        final int size;
        final PoolWorker[] eventLoops;
        long n;

        FixedSchedulerPool(int poolSize) {
            this.size = poolSize;
            this.eventLoops = new PoolWorker[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.eventLoops[i] = new PoolWorker((ThreadFactory)THREAD_FACTORY);
            }
        }

        public PoolWorker getEventLoop() {
            return this.eventLoops[(int)(this.n++ % (long)this.size)];
        }
    }
}

