/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.DefaultPartition;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.Partition;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultCouchbaseBucketConfig
extends AbstractBucketConfig
implements CouchbaseBucketConfig {
    private final PartitionInfo partitionInfo;
    private final List<NodeInfo> partitionHosts;
    private final boolean tainted;
    private final long rev;

    @JsonCreator
    public DefaultCouchbaseBucketConfig(@JsonProperty(value="rev") long rev, @JsonProperty(value="name") String name, @JsonProperty(value="nodeLocator") String locator, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="vBucketServerMap") PartitionInfo partitionInfo, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos) {
        super(name, BucketNodeLocator.fromConfig(locator), uri, streamingUri, nodeInfos, portInfos);
        this.partitionInfo = partitionInfo;
        this.tainted = !partitionInfo.forwardPartitions().isEmpty();
        this.partitionHosts = DefaultCouchbaseBucketConfig.buildPartitionHosts(nodeInfos, partitionInfo);
        this.rev = rev;
    }

    private static List<NodeInfo> buildPartitionHosts(List<NodeInfo> nodeInfos, PartitionInfo partitionInfo) {
        ArrayList<NodeInfo> partitionHosts = new ArrayList<NodeInfo>();
        for (String rawHost : partitionInfo.partitionHosts()) {
            InetAddress convertedHost = null;
            try {
                convertedHost = InetAddress.getByName(rawHost);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Could not resolve " + rawHost + "on config building.");
            }
            for (NodeInfo nodeInfo : nodeInfos) {
                if (!nodeInfo.hostname().equals(convertedHost)) continue;
                partitionHosts.add(nodeInfo);
            }
        }
        if (partitionHosts.size() != partitionInfo.partitionHosts().size()) {
            throw new ConfigurationException("Partition size is not equal after conversion, this is a bug.");
        }
        return partitionHosts;
    }

    @Override
    public List<NodeInfo> partitionHosts() {
        return this.partitionHosts;
    }

    @Override
    public List<Partition> partitions() {
        return this.partitionInfo.partitions();
    }

    @Override
    public int numberOfReplicas() {
        return this.partitionInfo.numberOfReplicas();
    }

    @Override
    public boolean tainted() {
        return this.tainted;
    }

    @Override
    public long rev() {
        return this.rev;
    }

    @Override
    public BucketType type() {
        return BucketType.COUCHBASE;
    }

    public String toString() {
        return "DefaultCouchbaseBucketConfig{name='" + this.name() + '\'' + ", locator=" + (Object)((Object)this.locator()) + ", uri='" + this.uri() + '\'' + ", streamingUri='" + this.streamingUri() + '\'' + ", nodeInfo=" + this.nodes() + ", partitionInfo=" + this.partitionInfo + ", tainted=" + this.tainted + ", rev=" + this.rev + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class PartitionInfo {
        private final int numberOfReplicas;
        private final List<String> partitionHosts;
        private final List<Partition> partitions;
        private final List<Partition> forwardPartitions;

        PartitionInfo(@JsonProperty(value="numReplicas") int numberOfReplicas, @JsonProperty(value="serverList") List<String> partitionHosts, @JsonProperty(value="vBucketMap") List<List<Short>> partitions, @JsonProperty(value="vBucketMapForward") List<List<Short>> forwardPartitions) {
            this.numberOfReplicas = numberOfReplicas;
            PartitionInfo.trimPort(partitionHosts);
            this.partitionHosts = partitionHosts;
            this.partitions = PartitionInfo.fromPartitionList(partitions);
            this.forwardPartitions = PartitionInfo.fromPartitionList(forwardPartitions);
        }

        public int numberOfReplicas() {
            return this.numberOfReplicas;
        }

        public List<String> partitionHosts() {
            return this.partitionHosts;
        }

        public List<Partition> partitions() {
            return this.partitions;
        }

        public List<Partition> forwardPartitions() {
            return this.forwardPartitions;
        }

        private static void trimPort(List<String> input) {
            for (int i = 0; i < input.size(); ++i) {
                String[] parts = input.get(i).split(":");
                input.set(i, parts[0]);
            }
        }

        private static List<Partition> fromPartitionList(List<List<Short>> input) {
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            if (input == null) {
                return partitions;
            }
            for (List<Short> partition : input) {
                short master = partition.remove(0);
                short[] replicas = new short[partition.size()];
                int i = 0;
                for (short replica : partition) {
                    replicas[i++] = replica;
                }
                partitions.add(new DefaultPartition(master, replicas));
            }
            return partitions;
        }

        public String toString() {
            return "PartitionInfo{numberOfReplicas=" + this.numberOfReplicas + ", partitionHosts=" + this.partitionHosts + ", partitions=" + this.partitions + ", forwardPartitions=" + this.forwardPartitions + '}';
        }
    }
}

