/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.config.ConfigEndpoint;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.config.BucketStreamingRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.service.AbstractService;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.strategies.RandomSelectionStrategy;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;

public class ConfigService
extends AbstractService {
    private static final SelectionStrategy strategy = new RandomSelectionStrategy();
    private static final Service.EndpointFactory factory = new ConfigEndpointFactory();
    private static final int INITIAL_ENDPOINTS = 1;
    private final String hostname;
    private final String bucket;
    private final String password;
    private final int port;
    private final CoreEnvironment env;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final List<Endpoint> pinnedEndpoints = new ArrayList<Endpoint>();

    public ConfigService(String hostname, String bucket, String password, int port, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        super(hostname, bucket, password, port, env, 1, strategy, responseBuffer, factory);
        this.hostname = hostname;
        this.bucket = bucket;
        this.password = password;
        this.port = port;
        this.env = env;
        this.responseBuffer = responseBuffer;
    }

    @Override
    public ServiceType type() {
        return ServiceType.CONFIG;
    }

    @Override
    public void send(final CouchbaseRequest request) {
        if (request instanceof BucketStreamingRequest) {
            final Endpoint endpoint = factory.create(this.hostname, this.bucket, this.password, this.port, this.env, this.responseBuffer);
            this.endpointStates.add(endpoint.states());
            endpoint.connect().subscribe((Subscriber)new Subscriber<LifecycleState>(){

                public void onCompleted() {
                    ConfigService.this.pinnedEndpoints.add(endpoint);
                    endpoint.send(request);
                    endpoint.send(SignalFlush.INSTANCE);
                }

                public void onError(Throwable e) {
                    request.observable().onError(e);
                }

                public void onNext(LifecycleState state) {
                }
            });
        } else {
            super.send(request);
        }
    }

    static class ConfigEndpointFactory
    implements Service.EndpointFactory {
        ConfigEndpointFactory() {
        }

        @Override
        public Endpoint create(String hostname, String bucket, String password, int port, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
            return new ConfigEndpoint(hostname, bucket, password, port, env, responseBuffer);
        }
    }
}

