/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.cluster;

import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.cluster.ClusterRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SeedNodesRequest
extends AbstractCouchbaseRequest
implements ClusterRequest {
    private static final String DEFAULT_HOSTNAME = "localhost";
    private Set<InetAddress> nodes;

    public SeedNodesRequest() {
        this(DEFAULT_HOSTNAME);
    }

    public SeedNodesRequest(String ... nodes) {
        this(Arrays.asList(nodes));
    }

    public SeedNodesRequest(List<String> nodes) {
        super(null, null);
        if (nodes == null || nodes.isEmpty()) {
            throw new ConfigurationException("Empty or null bootstrap list provided.");
        }
        HashSet<InetAddress> parsedNodes = new HashSet<InetAddress>();
        for (String node : nodes) {
            if (node == null || node.isEmpty()) {
                throw new ConfigurationException("Empty or null host in bootstrap list.");
            }
            try {
                parsedNodes.add(InetAddress.getByName(node));
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host " + node + " in bootstrap list.", e);
            }
        }
        this.nodes = parsedNodes;
    }

    public Set<InetAddress> nodes() {
        return this.nodes;
    }
}

