/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.refresher.AbstractRefresher;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.config.BucketStreamingRequest;
import com.couchbase.client.core.message.config.BucketStreamingResponse;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class HttpRefresher
extends AbstractRefresher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(HttpRefresher.class);
    private static final String TERSE_PATH = "/pools/default/bs/";
    private static final String VERBOSE_PATH = "/pools/default/bucketsStreaming/";

    public HttpRefresher(ClusterFacade cluster) {
        super(cluster);
    }

    @Override
    public Observable<Boolean> registerBucket(final String name, final String password) {
        LOGGER.debug("Registering bucket " + name + ".");
        return super.registerBucket(name, password).flatMap((Func1)new Func1<Boolean, Observable<BucketStreamingResponse>>(){

            public Observable<BucketStreamingResponse> call(Boolean aBoolean) {
                return HttpRefresher.this.cluster().send(new BucketStreamingRequest(HttpRefresher.TERSE_PATH, name, password));
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<BucketStreamingResponse>>(){

            public Observable<BucketStreamingResponse> call(Throwable throwable) {
                return HttpRefresher.this.cluster().send(new BucketStreamingRequest(HttpRefresher.VERBOSE_PATH, name, password));
            }
        }).map((Func1)new Func1<BucketStreamingResponse, Boolean>(){

            public Boolean call(final BucketStreamingResponse response) {
                response.configs().map((Func1)new Func1<String, String>(){

                    public String call(String s) {
                        return s.replace("$HOST", response.host());
                    }
                }).subscribe((Action1)new Action1<String>(){

                    public void call(String rawConfig) {
                        HttpRefresher.this.pushConfig(rawConfig);
                    }
                });
                return true;
            }
        });
    }

    @Override
    public Observable<Boolean> deregisterBucket(String name) {
        LOGGER.debug("Deregistering bucket " + name + ".");
        return super.deregisterBucket(name);
    }

    @Override
    public Observable<Boolean> shutdown() {
        return null;
    }

    @Override
    public void markTainted(BucketConfig config) {
    }

    @Override
    public void markUntainted(BucketConfig config) {
    }

    @Override
    public void refresh(ClusterConfig config) {
    }
}

