/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.Loader;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.internal.AddNodeRequest;
import com.couchbase.client.core.message.internal.AddNodeResponse;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.AddServiceResponse;
import com.couchbase.client.core.service.ServiceType;
import java.net.InetAddress;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

public abstract class AbstractLoader
implements Loader {
    private final ClusterFacade cluster;
    private final CoreEnvironment environment;
    private final ServiceType serviceType;
    private final LoaderType loaderType;

    protected AbstractLoader(LoaderType loaderType, ServiceType serviceType, ClusterFacade cluster, CoreEnvironment environment) {
        this.loaderType = loaderType;
        this.serviceType = serviceType;
        this.cluster = cluster;
        this.environment = environment;
    }

    protected abstract int port();

    protected abstract Observable<String> discoverConfig(String var1, String var2, InetAddress var3);

    @Override
    public Observable<Tuple2<LoaderType, BucketConfig>> loadConfig(Set<InetAddress> seedNodes, final String bucket, final String password) {
        return Observable.from(seedNodes).subscribeOn(this.env().scheduler()).flatMap((Func1)new Func1<InetAddress, Observable<AddNodeResponse>>(){

            public Observable<AddNodeResponse> call(InetAddress address) {
                return AbstractLoader.this.cluster.send(new AddNodeRequest(address));
            }
        }).flatMap((Func1)new Func1<AddNodeResponse, Observable<AddServiceResponse>>(){

            public Observable<AddServiceResponse> call(AddNodeResponse response) {
                if (!response.status().isSuccess()) {
                    return Observable.error((Throwable)new IllegalStateException("Could not add node for config loading."));
                }
                return AbstractLoader.this.cluster.send(new AddServiceRequest(AbstractLoader.this.serviceType, bucket, password, AbstractLoader.this.port(), response.hostname()));
            }
        }).flatMap((Func1)new Func1<AddServiceResponse, Observable<String>>(){

            public Observable<String> call(AddServiceResponse response) {
                if (!response.status().isSuccess()) {
                    return Observable.error((Throwable)new IllegalStateException("Could not add service for config loading."));
                }
                return AbstractLoader.this.discoverConfig(bucket, password, response.hostname());
            }
        }).map((Func1)new Func1<String, Tuple2<LoaderType, BucketConfig>>(){

            public Tuple2<LoaderType, BucketConfig> call(String rawConfig) {
                BucketConfig config = BucketConfigParser.parse(rawConfig);
                config.password(password);
                return Tuple.create(AbstractLoader.this.loaderType, config);
            }
        });
    }

    protected ClusterFacade cluster() {
        return this.cluster;
    }

    protected CoreEnvironment env() {
        return this.environment;
    }

    protected String replaceHostWildcard(String input, InetAddress hostname) {
        return input.replace("$HOST", hostname.getHostName());
    }
}

