/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.DefaultClusterConfig;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.CarrierLoader;
import com.couchbase.client.core.config.loader.HttpLoader;
import com.couchbase.client.core.config.loader.Loader;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.config.refresher.CarrierRefresher;
import com.couchbase.client.core.config.refresher.HttpRefresher;
import com.couchbase.client.core.config.refresher.Refresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ConfigurationProvider.class);
    private final ClusterFacade cluster;
    private final PublishSubject<ClusterConfig> configObservable;
    private final AtomicReference<ClusterConfig> currentConfig;
    private final AtomicReference<Set<InetAddress>> seedHosts;
    private final List<Loader> loaderChain;
    private final Map<LoaderType, Refresher> refreshers;
    private final CoreEnvironment environment;
    private volatile boolean bootstrapped;

    public DefaultConfigurationProvider(final ClusterFacade cluster, final CoreEnvironment environment) {
        this(cluster, environment, Arrays.asList(new CarrierLoader(cluster, environment), new HttpLoader(cluster, environment)), (Map<LoaderType, Refresher>)new HashMap<LoaderType, Refresher>(){
            {
                this.put(LoaderType.Carrier, new CarrierRefresher(environment, cluster));
                this.put(LoaderType.HTTP, new HttpRefresher(cluster));
            }
        });
    }

    public DefaultConfigurationProvider(ClusterFacade cluster, CoreEnvironment environment, List<Loader> loaderChain, Map<LoaderType, Refresher> refreshers) {
        if (cluster == null) {
            throw new IllegalArgumentException("A cluster reference needs to be provided");
        }
        if (loaderChain == null || loaderChain.isEmpty()) {
            throw new IllegalArgumentException("At least one config loader needs to be provided");
        }
        this.cluster = cluster;
        this.loaderChain = loaderChain;
        this.refreshers = refreshers;
        this.environment = environment;
        this.configObservable = PublishSubject.create();
        this.seedHosts = new AtomicReference();
        this.bootstrapped = false;
        this.currentConfig = new AtomicReference<DefaultClusterConfig>(new DefaultClusterConfig());
        Observable.from(refreshers.values()).doOnNext((Action1)new Action1<Refresher>(){

            public void call(Refresher refresher) {
                refresher.provider(DefaultConfigurationProvider.this);
            }
        }).flatMap((Func1)new Func1<Refresher, Observable<BucketConfig>>(){

            public Observable<BucketConfig> call(Refresher refresher) {
                return refresher.configs();
            }
        }).subscribe((Action1)new Action1<BucketConfig>(){

            public void call(BucketConfig bucketConfig) {
                DefaultConfigurationProvider.this.upsertBucketConfig(bucketConfig);
            }
        });
    }

    @Override
    public Observable<ClusterConfig> configs() {
        return this.configObservable;
    }

    @Override
    public ClusterConfig config() {
        return this.currentConfig.get();
    }

    @Override
    public boolean seedHosts(Set<InetAddress> hosts, boolean shuffle) {
        if (this.bootstrapped) {
            LOGGER.debug("Seed hosts called with {}, but already bootstrapped.", (Object)hosts);
            return false;
        }
        LOGGER.debug("Setting seed hosts to {}", (Object)hosts);
        if (shuffle) {
            ArrayList<InetAddress> hostsList = new ArrayList<InetAddress>(hosts);
            Collections.shuffle(hostsList);
            this.seedHosts.set(new HashSet<InetAddress>(hostsList));
        } else {
            this.seedHosts.set(hosts);
        }
        return true;
    }

    @Override
    public Observable<ClusterConfig> openBucket(final String bucket, String password) {
        if (this.currentConfig.get() != null && this.currentConfig.get().hasBucket(bucket)) {
            return Observable.just((Object)this.currentConfig.get());
        }
        if (this.seedHosts.get() == null || this.seedHosts.get().isEmpty()) {
            return Observable.error((Throwable)new ConfigurationException("Seed node list not provided or empty."));
        }
        Observable observable = this.loaderChain.get(0).loadConfig(this.seedHosts.get(), bucket, password);
        for (int i = 1; i < this.loaderChain.size(); ++i) {
            observable = observable.onErrorResumeNext(this.loaderChain.get(i).loadConfig(this.seedHosts.get(), bucket, password));
        }
        return observable.doOnNext((Action1)new Action1<Tuple2<LoaderType, BucketConfig>>(){

            public void call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.this.registerBucketForRefresh(tuple.value1(), tuple.value2());
            }
        }).map((Func1)new Func1<Tuple2<LoaderType, BucketConfig>, ClusterConfig>(){

            public ClusterConfig call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.this.upsertBucketConfig(tuple.value2());
                return (ClusterConfig)DefaultConfigurationProvider.this.currentConfig.get();
            }
        }).doOnNext((Action1)new Action1<ClusterConfig>(){

            public void call(ClusterConfig clusterConfig) {
                LOGGER.info("Opened bucket " + bucket);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<ClusterConfig>>(){

            public Observable<ClusterConfig> call(Throwable throwable) {
                return Observable.error((Throwable)new ConfigurationException("Could not open bucket.", throwable));
            }
        });
    }

    @Override
    public Observable<ClusterConfig> closeBucket(String name) {
        return Observable.just((Object)name).map((Func1)new Func1<String, ClusterConfig>(){

            public ClusterConfig call(String bucket) {
                DefaultConfigurationProvider.this.removeBucketConfig(bucket);
                LOGGER.info("Closed bucket " + bucket);
                return (ClusterConfig)DefaultConfigurationProvider.this.currentConfig.get();
            }
        });
    }

    @Override
    public Observable<Boolean> closeBuckets() {
        if (this.currentConfig.get() == null || this.currentConfig.get().bucketConfigs().isEmpty()) {
            return Observable.just((Object)true);
        }
        HashSet<String> configs = new HashSet<String>(this.currentConfig.get().bucketConfigs().keySet());
        return Observable.from(configs).subscribeOn(this.environment.scheduler()).flatMap((Func1)new Func1<String, Observable<? extends ClusterConfig>>(){

            public Observable<? extends ClusterConfig> call(String bucketName) {
                return DefaultConfigurationProvider.this.closeBucket(bucketName);
            }
        }).last().map((Func1)new Func1<ClusterConfig, Boolean>(){

            public Boolean call(ClusterConfig clusterConfig) {
                return true;
            }
        });
    }

    @Override
    public void proposeBucketConfig(String bucket, String rawConfig) {
        BucketConfig config = BucketConfigParser.parse(rawConfig);
        config.password(this.currentConfig.get().bucketConfig(bucket).password());
        this.upsertBucketConfig(config);
    }

    @Override
    public void signalOutdated() {
        for (Refresher refresher : this.refreshers.values()) {
            refresher.refresh(this.currentConfig.get());
        }
    }

    private void registerBucketForRefresh(LoaderType loaderType, BucketConfig bucketConfig) {
        Refresher refresher = this.refreshers.get((Object)loaderType);
        if (refresher == null) {
            throw new IllegalStateException("Could not find refresher for loader type: " + (Object)((Object)loaderType));
        }
        refresher.registerBucket(bucketConfig.name(), bucketConfig.password()).subscribe();
    }

    private void upsertBucketConfig(BucketConfig config) {
        ClusterConfig cluster = this.currentConfig.get();
        if (config.rev() > 0L && cluster.bucketConfig(config.name()) != null && config.rev() <= cluster.bucketConfig(config.name()).rev()) {
            return;
        }
        cluster.setBucketConfig(config.name(), config);
        LOGGER.debug("Applying new configuration {}", (Object)config);
        this.currentConfig.set(cluster);
        boolean tainted = config.tainted();
        for (Refresher refresher : this.refreshers.values()) {
            if (tainted) {
                refresher.markTainted(config);
                continue;
            }
            refresher.markUntainted(config);
        }
        this.configObservable.onNext((Object)this.currentConfig.get());
    }

    private void removeBucketConfig(String name) {
        ClusterConfig cluster = this.currentConfig.get();
        cluster.deleteBucketConfig(name);
        this.currentConfig.set(cluster);
        this.configObservable.onNext((Object)this.currentConfig.get());
    }
}

