/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.jackson.core.json;

import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonGenerationException;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonStreamContext;
import com.couchbase.client.deps.com.fasterxml.jackson.core.json.DupDetector;

public class JsonWriteContext
extends JsonStreamContext {
    public static final int STATUS_OK_AS_IS = 0;
    public static final int STATUS_OK_AFTER_COMMA = 1;
    public static final int STATUS_OK_AFTER_COLON = 2;
    public static final int STATUS_OK_AFTER_SPACE = 3;
    public static final int STATUS_EXPECT_VALUE = 4;
    public static final int STATUS_EXPECT_NAME = 5;
    protected final JsonWriteContext _parent;
    protected final DupDetector _dups;
    protected JsonWriteContext _child = null;
    protected String _currentName;
    protected boolean _gotName;

    protected JsonWriteContext(int type, JsonWriteContext parent, DupDetector dups) {
        this._type = type;
        this._parent = parent;
        this._dups = dups;
        this._index = -1;
    }

    protected JsonWriteContext reset(int type) {
        this._type = type;
        this._index = -1;
        this._currentName = null;
        this._gotName = false;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    @Deprecated
    public static JsonWriteContext createRootContext() {
        return JsonWriteContext.createRootContext(null);
    }

    public static JsonWriteContext createRootContext(DupDetector dd) {
        return new JsonWriteContext(0, null, dd);
    }

    public JsonWriteContext createChildArrayContext() {
        JsonWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new JsonWriteContext(1, this, this._dups == null ? null : this._dups.child());
            return ctxt;
        }
        return ctxt.reset(1);
    }

    public JsonWriteContext createChildObjectContext() {
        JsonWriteContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new JsonWriteContext(2, this, this._dups == null ? null : this._dups.child());
            return ctxt;
        }
        return ctxt.reset(2);
    }

    @Override
    public final JsonWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public final int writeFieldName(String name) throws JsonProcessingException {
        this._gotName = true;
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
        return this._index < 0 ? 0 : 1;
    }

    private final void _checkDup(DupDetector dd, String name) throws JsonProcessingException {
        if (dd.isDup(name)) {
            throw new JsonGenerationException("Duplicate field '" + name + "'");
        }
    }

    public final int writeValue() {
        if (this._type == 2) {
            this._gotName = false;
            ++this._index;
            return 2;
        }
        if (this._type == 1) {
            int ix;
            return (ix = this._index++) < 0 ? 0 : 1;
        }
        ++this._index;
        return this._index == 0 ? 0 : 3;
    }

    protected void appendDesc(StringBuilder sb) {
        if (this._type == 2) {
            sb.append('{');
            if (this._currentName != null) {
                sb.append('\"');
                sb.append(this._currentName);
                sb.append('\"');
            } else {
                sb.append('?');
            }
            sb.append('}');
        } else if (this._type == 1) {
            sb.append('[');
            sb.append(this.getCurrentIndex());
            sb.append(']');
        } else {
            sb.append("/");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.appendDesc(sb);
        return sb.toString();
    }
}

