/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.config.BucketConfigRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import java.net.InetAddress;
import java.util.Set;

public class ConfigLocator
implements Locator {
    private long counter = 0L;

    @Override
    public Node[] locate(CouchbaseRequest request, Set<Node> nodes, ClusterConfig config) {
        if (request instanceof BucketConfigRequest) {
            BucketConfigRequest req = (BucketConfigRequest)request;
            InetAddress hostname = req.hostname();
            for (Node node : nodes) {
                if (hostname != null && !node.hostname().equals(hostname)) continue;
                return new Node[]{node};
            }
        } else {
            int item = (int)this.counter % nodes.size();
            int i = 0;
            for (Node node : nodes) {
                if (i++ != item) continue;
                return new Node[]{node};
            }
        }
        return new Node[0];
    }
}

