/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.RequestCancelledException;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ResponseHandler;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.MessageToMessageCodec;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public abstract class AbstractGenericHandler<RESPONSE, ENCODED, REQUEST extends CouchbaseRequest>
extends MessageToMessageCodec<RESPONSE, REQUEST> {
    protected static final Charset CHARSET = CharsetUtil.UTF_8;
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(AbstractGenericHandler.class);
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final AbstractEndpoint endpoint;
    private final Queue<REQUEST> sentRequestQueue;
    private REQUEST currentRequest;

    protected AbstractGenericHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer) {
        this(endpoint, responseBuffer, new ArrayDeque());
    }

    protected AbstractGenericHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<REQUEST> queue) {
        this.endpoint = endpoint;
        this.responseBuffer = responseBuffer;
        this.sentRequestQueue = queue;
    }

    protected abstract ENCODED encodeRequest(ChannelHandlerContext var1, REQUEST var2) throws Exception;

    protected abstract CouchbaseResponse decodeResponse(ChannelHandlerContext var1, RESPONSE var2) throws Exception;

    @Override
    protected void encode(ChannelHandlerContext ctx, REQUEST msg, List<Object> out) throws Exception {
        ENCODED request = this.encodeRequest(ctx, msg);
        this.sentRequestQueue.offer(msg);
        out.add(request);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, RESPONSE msg, List<Object> out) throws Exception {
        if (this.currentRequest == null) {
            this.currentRequest = (CouchbaseRequest)this.sentRequestQueue.poll();
        }
        REQUEST current = this.currentRequest;
        CouchbaseResponse response = this.decodeResponse(ctx, msg);
        if (response != null) {
            this.responseBuffer.publishEvent(ResponseHandler.RESPONSE_TRANSLATOR, response, current.observable());
            if (response.status() != ResponseStatus.CHUNKED) {
                this.currentRequest = null;
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug(AbstractGenericHandler.logIdent(ctx, this.endpoint) + "Channel Inactive.");
        this.endpoint.notifyChannelInactive();
        ctx.fireChannelInactive();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug(AbstractGenericHandler.logIdent(ctx, this.endpoint) + "Channel Active.");
        ctx.fireChannelActive();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (!ctx.channel().isWritable()) {
            ctx.flush();
        }
        ctx.fireChannelWritabilityChanged();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(AbstractGenericHandler.logIdent(ctx, this.endpoint) + "Connection reset by peer: " + cause.getMessage(), cause);
            } else {
                LOGGER.info(AbstractGenericHandler.logIdent(ctx, this.endpoint) + "Connection reset by peer: " + cause.getMessage());
            }
            this.handleOutstandingOperations(ctx);
        } else {
            LOGGER.warn(AbstractGenericHandler.logIdent(ctx, this.endpoint) + "Caught unknown exception: " + cause.getMessage(), cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.handleOutstandingOperations(ctx);
    }

    private void handleOutstandingOperations(ChannelHandlerContext ctx) {
        if (this.sentRequestQueue.isEmpty()) {
            LOGGER.trace(AbstractGenericHandler.logIdent(ctx, this.endpoint) + "Not cancelling operations - sent queue is empty.");
            return;
        }
        LOGGER.debug(AbstractGenericHandler.logIdent(ctx, this.endpoint) + "Cancelling " + this.sentRequestQueue.size() + " outstanding requests.");
        while (!this.sentRequestQueue.isEmpty()) {
            CouchbaseRequest req = (CouchbaseRequest)this.sentRequestQueue.poll();
            try {
                req.observable().onError((Throwable)new RequestCancelledException("Request cancelled in-flight."));
            }
            catch (Exception ex) {
                LOGGER.info("Exception thrown while cancelling outstanding operation: " + req, ex);
            }
        }
    }

    protected REQUEST currentRequest() {
        return this.currentRequest;
    }

    protected CoreEnvironment env() {
        return this.endpoint.environment();
    }

    protected void currentRequest(REQUEST currentRequest) {
        this.currentRequest = currentRequest;
    }

    protected static String logIdent(ChannelHandlerContext ctx, Endpoint endpoint) {
        return "[" + ctx.channel().remoteAddress() + "][" + endpoint.getClass().getSimpleName() + "]: ";
    }
}

