/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.refresher.AbstractRefresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

public class CarrierRefresher
extends AbstractRefresher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CarrierRefresher.class);
    private final Map<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();
    private final CoreEnvironment environment;

    public CarrierRefresher(CoreEnvironment environment, ClusterFacade cluster) {
        super(cluster);
        this.environment = environment;
    }

    @Override
    public Observable<Boolean> shutdown() {
        return Observable.just((Object)true);
    }

    @Override
    public void markTainted(final BucketConfig config) {
        if (this.subscriptions.containsKey(config.name())) {
            return;
        }
        LOGGER.debug("Config for bucket \"" + config.name() + "\" marked as tainted, starting polling.");
        Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Object>(){

            public void call(Subscriber<? super Object> subscriber) {
                Subscription subscription = CarrierRefresher.this.environment.scheduler().createWorker().schedulePeriodically(new Action0(){

                    public void call() {
                        final InetAddress hostname = config.nodes().get(0).hostname();
                        CarrierRefresher.this.cluster().send(new GetBucketConfigRequest(config.name(), hostname)).subscribe((Action1)new Action1<GetBucketConfigResponse>(){

                            public void call(GetBucketConfigResponse res) {
                                String rawConfig = res.content().toString(CharsetUtil.UTF_8).replace("$HOST", hostname.getHostName());
                                CarrierRefresher.this.provider().proposeBucketConfig(res.bucket(), rawConfig);
                            }
                        });
                    }
                }, 0L, 1L, TimeUnit.SECONDS);
                CarrierRefresher.this.subscriptions.put(config.name(), subscription);
            }
        }).subscribe();
    }

    @Override
    public void markUntainted(BucketConfig config) {
        Subscription subscription = this.subscriptions.get(config.name());
        if (subscription != null) {
            LOGGER.debug("Config for bucket \"" + config.name() + "\" marked as untainted, stopping polling.");
            subscription.unsubscribe();
            this.subscriptions.remove(config.name());
        }
    }

    @Override
    public void refresh(ClusterConfig config) {
        Observable.from(config.bucketConfigs().values()).filter((Func1)new Func1<BucketConfig, Boolean>(){

            public Boolean call(BucketConfig config) {
                return CarrierRefresher.this.registrations().containsKey(config.name());
            }
        }).subscribe((Action1)new Action1<BucketConfig>(){

            public void call(final BucketConfig config) {
                InetAddress hostname = config.nodes().get(0).hostname();
                CarrierRefresher.this.cluster().send(new GetBucketConfigRequest(config.name(), hostname)).map((Func1)new Func1<GetBucketConfigResponse, String>(){

                    public String call(GetBucketConfigResponse response) {
                        String raw = response.content().toString(CharsetUtil.UTF_8);
                        return raw.replace("$HOST", response.hostname().getHostName());
                    }
                }).subscribe((Action1)new Action1<String>(){

                    public void call(String rawConfig) {
                        CarrierRefresher.this.provider().proposeBucketConfig(config.name(), rawConfig);
                    }
                });
            }
        });
    }
}

