/*
 * Decompiled with CFR 0.152.
 */
package com.convertigo.jenkins.plugins.jenkinsPluginsArtifact;

import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.JenkinsPluginException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ZipFile {
    List<File> carfileList;
    List<Path> filePathList;
    Map<Path, String> projectDirMap;
    boolean bflag;
    static final String expression = "/convertigo/project/property[@name='name']/java.lang.String/@value";
    XPath xPath = XPathFactory.newInstance().newXPath();

    public ZipFile() {
        this.carfileList = new ArrayList<File>();
        this.filePathList = new ArrayList<Path>();
        this.projectDirMap = new HashMap<Path, String>();
    }

    public ZipFile(Path workspacePath) {
        this.bflag = true;
        this.carfileList = new ArrayList<File>();
        this.filePathList = new ArrayList<Path>();
        this.projectDirMap = new HashMap<Path, String>();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
    }

    public void doZip(Path workspacePath) throws JenkinsPluginException {
        this.generatePrjDirList(workspacePath);
        if (this.projectDirMap != null && this.projectDirMap.size() != 0) {
            for (Map.Entry<Path, String> entry : this.projectDirMap.entrySet()) {
                this.cleanFilePathList();
                Path projectPath = entry.getKey();
                String projectName = entry.getValue();
                this.generateFilePathList(projectPath.toFile());
                this.zipProject(this.filePathList, projectPath, projectName);
            }
        }
    }

    public void zipProject(List<Path> filePathList, Path projectPath, String zipFileName) {
        byte[] buffer = new byte[1024];
        try {
            Path dstZipFilePath = projectPath.getParent();
            Path dirName = dstZipFilePath.getFileName();
            String relativePath = zipFileName;
            if (zipFileName != null && !zipFileName.equals(dirName.toString())) {
                relativePath = zipFileName;
            }
            Path pathTmp = dstZipFilePath.resolve(zipFileName + ".car");
            File zipFile = pathTmp.toFile();
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            System.out.println("Output to : " + dstZipFilePath.toString());
            for (Path path : filePathList) {
                int len;
                System.out.println("File Added : " + path.toString());
                String zipEntryName = path.toString().replace(projectPath.toString(), relativePath);
                System.out.println("File Added : " + zipEntryName);
                zipEntryName = zipEntryName.replaceAll("\\\\", "/");
                ZipEntry ze = new ZipEntry(zipEntryName);
                zos.putNextEntry(ze);
                File f = path.toFile();
                FileInputStream in = new FileInputStream(f);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
            System.out.println("Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void generateFilePathList(File node) {
        if (node.isFile()) {
            this.filePathList.add(node.toPath());
        }
        if (node.isDirectory() && !node.getName().startsWith(".")) {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                this.generateFilePathList(new File(node, filename));
            }
        }
    }

    public void generatePrjDirList(Path dirPath) throws JenkinsPluginException {
        File[] files;
        String projectName = this.isSvnProjectDir(dirPath);
        if (projectName != null && !"".equals(projectName)) {
            this.projectDirMap.put(dirPath, projectName.replace(".xml", ""));
            Path carPath = dirPath.getParent().resolve(projectName.replace(".xml", "") + ".car");
            this.carfileList.add(carPath.toFile());
            return;
        }
        for (File file : files = dirPath.toFile().listFiles()) {
            if (!file.isDirectory() || file.getName().startsWith(".")) continue;
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            projectName = this.isSvnProjectDir(path);
            if (projectName != null && !"".equals(projectName)) {
                this.projectDirMap.put(path, projectName.replace(".xml", ""));
                Path carPath = path.getParent().resolve(projectName.replace(".xml", "") + ".car");
                this.carfileList.add(carPath.toFile());
                continue;
            }
            this.generatePrjDirList(path);
        }
    }

    private String isSvnProjectDir(Path dirPath) throws JenkinsPluginException {
        File[] files;
        String projectName = null;
        File dir = dirPath.toFile();
        for (File file : files = dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
            projectName = file.getName();
            if (this.parseXml(file, projectName)) {
                return projectName;
            }
            projectName = null;
        }
        return projectName;
    }

    private boolean parseXml(File file, String filename) throws JenkinsPluginException {
        String xmlfileName = filename.replace(".xml", "");
        String projectName = null;
        FileInputStream inf = null;
        try {
            inf = new FileInputStream(file);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(inf);
            projectName = (String)this.xPath.compile(expression).evaluate(xmlDocument, XPathConstants.STRING);
        }
        catch (FileNotFoundException e) {
            throw new JenkinsPluginException("fail to find directory of project " + filename + " " + e.getMessage());
        }
        catch (SAXException e) {
            throw new JenkinsPluginException("fail to find directory of project " + filename + " " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new JenkinsPluginException("fail to find directory of project " + filename + " " + e.getMessage());
        }
        catch (XPathExpressionException e) {
            throw new JenkinsPluginException("fail to find directory of project " + filename + " " + e.getMessage());
        }
        catch (IOException e) {
            throw new JenkinsPluginException("fail to find directory of project " + filename + " " + e.getMessage());
        }
        finally {
            if (inf != null) {
                try {
                    inf.close();
                }
                catch (IOException e) {
                    throw new JenkinsPluginException("fail to find directory of project " + filename + " " + e.getMessage());
                }
            }
        }
        return projectName != null && xmlfileName.equals(projectName);
    }

    public List<File> getFileList() {
        if (this.carfileList == null && this.carfileList.isEmpty()) {
            return null;
        }
        for (File file : this.carfileList) {
            if (file.exists()) continue;
            return null;
        }
        return this.carfileList;
    }

    public void cleanFilePathList() {
        this.filePathList.clear();
    }
}

