/*
 * Decompiled with CFR 0.152.
 */
package com.convertigo.jenkins.plugins.jenkinsPluginsArtifact;

import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.Deployment;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.JenkinsPluginException;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.Project;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.TestCase;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.TestCaseBlock;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.TestResultAnalyzer;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.ZipFile;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.block.EnableTestCaseBlock;
import com.google.common.collect.ImmutableList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.w3c.dom.Document;

public class DeploymentBuilder
extends Builder {
    private final String url;
    private final String userId;
    private final String password;
    private final boolean enableAutoDeploy;
    private final boolean enableZipFile;
    private final List<TestCaseBlock> testcaseblock;
    private final boolean enableTestCase;

    @DataBoundConstructor
    public DeploymentBuilder(String url, String userId, String password, boolean enableZipFile, boolean enableAutoDeploy, EnableTestCaseBlock enableTestCase) {
        this.url = url;
        this.userId = userId;
        this.password = password;
        this.enableZipFile = enableZipFile;
        this.enableAutoDeploy = enableAutoDeploy;
        List<TestCaseBlock> list = this.testcaseblock = enableTestCase != null ? enableTestCase.getTestcaseblock() : null;
        if (enableTestCase != null) {
            this.enableTestCase = true;
            TestCaseBlock.setUserId(userId, false);
            TestCaseBlock.setUrl(url, false);
            TestCaseBlock.setPassword(password, false);
        } else {
            this.enableTestCase = false;
            TestCaseBlock.setUserId("", false);
            TestCaseBlock.setUrl("", false);
            TestCaseBlock.setPassword("", false);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public List<TestCaseBlock> getTestcaseblock() {
        return this.testcaseblock;
    }

    public boolean isEnableZipFile() {
        return this.enableZipFile;
    }

    public boolean isEnableAutoDeploy() {
        return this.enableAutoDeploy;
    }

    public boolean isEnableTestCase() {
        return this.enableTestCase;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        FilePath workspace = build.getWorkspace();
        StringBuilder logMsgSb = new StringBuilder("");
        if (this.enableAutoDeploy || this.enableZipFile) {
            try {
                Path path = null;
                URI uri = workspace.toURI();
                path = Paths.get(uri);
                ZipFile zipFiles = new ZipFile();
                List<File> list = null;
                zipFiles.doZip(path);
                list = zipFiles.getFileList();
                for (File file : list) {
                    listener.getLogger().println(file.toURI() + " to deploy \n");
                }
                if (this.enableAutoDeploy) {
                    Deployment dp = new Deployment(this.url, this.userId, this.password);
                    dp.deployMultiProjects(list);
                }
            }
            catch (IOException e) {
                logMsgSb.append(e.getMessage() + "\n");
            }
            catch (InterruptedException e) {
                logMsgSb.append(e.getMessage() + "\n");
            }
            catch (JenkinsPluginException e) {
                logMsgSb.append(e.getMessage() + "\n");
            }
        }
        if (this.enableTestCase && this.testcaseblock != null && this.testcaseblock.size() != 0) {
            EnvVars envVars = new EnvVars();
            try {
                envVars = build.getEnvironment((TaskListener)listener);
                String jobName = (String)envVars.get((Object)"JOB_NAME");
                boolean success = new File(workspace + File.separator + "TestReports").mkdir();
                String path = workspace.toString() + File.separator + "TestReports" + File.separator;
                TestCaseBlock.setUrl(this.url, false);
                TestCaseBlock.setUserId(this.userId, false);
                TestCaseBlock.setPassword(this.password, false);
                TestResultAnalyzer tra = new TestResultAnalyzer();
                Document doc = tra.generateXmlFile(jobName, path);
                String xmlPath = path + jobName + "_TestCaseReport.xml";
                String logMsg = TestCaseBlock.executTestCasesAndAnalyse(this.testcaseblock, doc, xmlPath);
                logMsgSb.append("\n\n" + logMsg + "\n");
            }
            catch (IOException e) {
                logMsgSb.append(e.getMessage() + "\n");
            }
            catch (InterruptedException e) {
                logMsgSb.append(e.getMessage() + "\n");
            }
            catch (JenkinsPluginException e) {
                logMsgSb.append(e.getMessage() + "\n");
            }
        }
        listener.getLogger().println(logMsgSb.toString());
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private boolean useFrench;
        private String url;
        private String password;
        private String userId;
        private List<TestCase> testcaseList;
        private static List<Project> projectList;
        private String projectname;
        private String testcasename;
        private String typename;
        private String type;
        private String transaction;
        private TestCase testcase;
        private List<TestCaseBlock> testcaseblock;
        private boolean enableTestCase;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckUrl(@QueryParameter String url) throws IOException, ServletException {
            if (url == null || url.isEmpty()) {
                return FormValidation.error((String)"Deployment Server Url is requied ");
            }
            try {
                URL urlreal = new URL(url);
                if (Deployment.pingUrl(url)) {
                    this.url = url;
                    TestCaseBlock.setUrl(url, false);
                    return FormValidation.ok();
                }
                TestCaseBlock.setUrl(url, false);
                return FormValidation.error((String)("Deployment Server Url " + url + " is not reachable "));
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"Deployment Server Url is not valid ");
            }
        }

        public FormValidation doCheckUserId(@QueryParameter String userId) throws IOException, ServletException {
            if (userId.isEmpty() || userId == null) {
                return FormValidation.error((String)"Please set a userId");
            }
            this.userId = userId;
            TestCaseBlock.setUserId(userId, false);
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String password) throws IOException, ServletException {
            if (password.isEmpty() || password == null) {
                return FormValidation.error((String)"Please set a password");
            }
            this.password = password;
            TestCaseBlock.setPassword(password, false);
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Convertigo Jenkins Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONArray list = formData.getJSONArray("Testcaseblock");
            this.save();
            return super.configure(req, formData);
        }

        public boolean getUseFrench() {
            return this.useFrench;
        }

        public String getProjectname() {
            return this.projectname;
        }

        public String getTestcasename() {
            return this.testcasename;
        }

        public String getTypename() {
            return this.typename;
        }

        public String getType() {
            return this.type;
        }

        public String getTransaction() {
            return this.transaction;
        }

        public boolean isEnableTestCase() {
            return this.enableTestCase;
        }

        public List<TestCaseBlock> getTestcaseblock() {
            return this.testcaseblock;
        }

        public void setTestcaseblock(List<TestCaseBlock> testcaseblock) {
            this.testcaseblock = testcaseblock;
        }

        public List<Descriptor> getTestcaseblockDescriptors() {
            Jenkins jenkins = Jenkins.getInstance();
            return ImmutableList.of((Object)jenkins.getDescriptor(TestCaseBlock.class));
        }
    }
}

